# Complete Optimization Problem and Solution: store_product

## 1. Problem Context and Goals

### Context  
A retail chain is focused on optimizing the allocation of products across its stores to maximize total sales revenue. The key decision involves determining the number of units of each product to allocate to each store. This decision must consider the sales potential of each product in each store, the total available units of each product, and the capacity of each store to handle inventory. Additionally, the allocation must adhere to business-defined thresholds: a minimum number of units must be allocated to ensure product presence in every store, and a maximum number of units must not be exceeded to prevent overstocking and maintain balanced inventory levels.

The sales potential of a product in a store represents the expected contribution of that product to total sales revenue. The total sales revenue is calculated by summing the product of the sales potential and the allocated units for each product-store combination. The business configuration includes a minimum allocation threshold of 10 units and a maximum allocation threshold of 100 units per product per store. These thresholds ensure operational efficiency and inventory balance across the retail chain.

### Goals  
The primary goal of this optimization is to maximize total sales revenue by strategically allocating products to stores. This is achieved by determining the optimal number of units of each product to allocate to each store, considering their sales potential, availability, and store capacities. Success is measured by the total sales revenue generated, which is directly influenced by the sales potential of each product in each store and the number of units allocated. The optimization ensures that the allocation respects store capacities, product availability, and the defined minimum and maximum allocation thresholds.

## 2. Constraints  

The optimization must adhere to the following constraints:  
1. **Store Capacity Constraint**: The total number of units allocated to a store across all products must not exceed the store's capacity. This ensures that the store can handle the allocated inventory without operational strain.  
2. **Product Availability Constraint**: The total number of units allocated for a product across all stores must not exceed the available units of that product. This ensures that the allocation does not exceed the available inventory.  
3. **Minimum Allocation Threshold**: The number of units allocated for a product to a store must be at least the minimum allocation threshold. This ensures a minimum presence of each product in every store.  
4. **Maximum Allocation Threshold**: The number of units allocated for a product to a store must not exceed the maximum allocation threshold. This prevents overstocking and ensures balanced inventory levels across stores.  

These constraints ensure that the allocation decisions are operationally feasible and aligned with business requirements.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Added allocation table for decision variables, updated business configuration logic with new scalar parameters, and ensured all mappings are complete.

CREATE TABLE sales_potential (
  store_id INTEGER,
  product_id INTEGER,
  sales_potential_value FLOAT
);

CREATE TABLE product_availability (
  product_id INTEGER,
  available_units INTEGER
);

CREATE TABLE store_capacity (
  store_id INTEGER,
  capacity INTEGER
);

CREATE TABLE allocation (
  store_id INTEGER,
  product_id INTEGER,
  allocation_value INTEGER
);
```

### Data Dictionary  
- **sales_potential**: Represents the expected sales contribution of a product in a specific store.  
  - *store_id*: Unique identifier for the store.  
  - *product_id*: Unique identifier for the product.  
  - *sales_potential_value*: The sales potential of the product in the store, used as a coefficient in the objective function.  

- **product_availability**: Represents the total available units of a product across all stores.  
  - *product_id*: Unique identifier for the product.  
  - *available_units*: The total available units of the product, used as an upper bound in the product availability constraint.  

- **store_capacity**: Represents the maximum number of units a store can handle.  
  - *store_id*: Unique identifier for the store.  
  - *capacity*: The maximum number of units the store can handle, used as an upper bound in the store capacity constraint.  

- **allocation**: Represents the number of units of a product allocated to a store.  
  - *store_id*: Unique identifier for the store.  
  - *product_id*: Unique identifier for the product.  
  - *allocation_value*: The number of units of the product allocated to the store, used as the decision variable in the optimization model.  


### Retrieved Values

**Query 1: This data is crucial for the objective function, as it represents the expected contribution of each product to total sales revenue.**

```sql
SELECT store_id, product_id, sales_potential_value FROM sales_potential;
```

**Results (CSV format):**
```csv
store_id,product_id,sales_potential_value
1,101,50.0
1,102,75.0
1,103,100.0
```

**Query 2: This data is essential for the product availability constraint, ensuring that the total allocation does not exceed the available inventory.**

```sql
SELECT product_id, available_units FROM product_availability;
```

**Results (CSV format):**
```csv
product_id,available_units
101,500
102,750
103,1000
```

**Query 3: This data is necessary for the store capacity constraint, ensuring that the total allocation to a store does not exceed its capacity.**

```sql
SELECT store_id, capacity FROM store_capacity;
```

**Results (CSV format):**
```csv
store_id,capacity
1,1000
2,1500
3,2000
```

**Query 4: This data represents the decision variables in the optimization model and is used to ensure that the allocation respects the minimum and maximum thresholds.**

```sql
SELECT store_id, product_id, allocation_value FROM allocation;
```

**Results (CSV format):**
```csv
store_id,product_id,allocation_value
1,101,50
1,102,75
1,103,100
```

**Query 5: This aggregated data helps ensure that the store capacity constraint is not violated.**

```sql
SELECT store_id, SUM(allocation_value) AS total_allocated_units FROM allocation GROUP BY store_id;
```

**Results (CSV format):**
```csv
store_id,total_allocated_units
1,225
```

**Query 6: This aggregated data helps ensure that the product availability constraint is not violated.**

```sql
SELECT product_id, SUM(allocation_value) AS total_allocated_units FROM allocation GROUP BY product_id;
```

**Results (CSV format):**
```csv
product_id,total_allocated_units
101,50
102,75
103,100
```

**Query 7: This data is useful for evaluating the current allocation against the sales potential and identifying opportunities for optimization.**

```sql
SELECT sp.store_id, sp.product_id, sp.sales_potential_value, a.allocation_value FROM sales_potential sp LEFT JOIN allocation a ON sp.store_id = a.store_id AND sp.product_id = a.product_id;
```

**Results (CSV format):**
```csv
store_id,product_id,sales_potential_value,allocation_value
1,101,50.0,50
1,102,75.0,75
1,103,100.0,100
```

**Query 8: This data helps in understanding the relationship between sales potential, current allocation, and store capacity, which is crucial for optimizing the allocation.**

```sql
SELECT sp.store_id, sp.product_id, sp.sales_potential_value, a.allocation_value, sc.capacity FROM sales_potential sp LEFT JOIN allocation a ON sp.store_id = a.store_id AND sp.product_id = a.product_id LEFT JOIN store_capacity sc ON sp.store_id = sc.store_id;
```

**Results (CSV format):**
```csv
store_id,product_id,sales_potential_value,allocation_value,capacity
1,101,50.0,50,1000
1,102,75.0,75,1000
1,103,100.0,100,1000
```

**Query 9: This data helps in understanding the relationship between sales potential, current allocation, and product availability, which is crucial for optimizing the allocation.**

```sql
SELECT sp.product_id, sp.sales_potential_value, a.allocation_value, pa.available_units FROM sales_potential sp LEFT JOIN allocation a ON sp.store_id = a.store_id AND sp.product_id = a.product_id LEFT JOIN product_availability pa ON sp.product_id = pa.product_id;
```

**Results (CSV format):**
```csv
product_id,sales_potential_value,allocation_value,available_units
101,50.0,50,500
102,75.0,75,750
103,100.0,100,1000
```

**Query 10: This aggregated data helps in identifying stores with the highest sales potential, which can be prioritized in the allocation process.**

```sql
SELECT store_id, SUM(sales_potential_value) AS total_sales_potential FROM sales_potential GROUP BY store_id;
```

**Results (CSV format):**
```csv
store_id,total_sales_potential
1,225.0
```

**Query 11: This aggregated data helps in identifying products with the highest sales potential, which can be prioritized in the allocation process.**

```sql
SELECT product_id, SUM(sales_potential_value) AS total_sales_potential FROM sales_potential GROUP BY product_id;
```

**Results (CSV format):**
```csv
product_id,total_sales_potential
101,50.0
102,75.0
103,100.0
```

