# Complete Optimization Problem and Solution: theme_gallery

## 1. Problem Context and Goals

### Context  
The theme gallery operates with the goal of maximizing its annual revenue from exhibitions. To achieve this, the gallery must strategically allocate artists to exhibitions based on their popularity and the ticket prices of the exhibitions. Each artist has a limited availability, and each exhibition requires a minimum number of artists to ensure its success. The gallery’s decision-making process involves determining the number of exhibitions each artist should participate in during the year. This decision is influenced by two key factors: the ticket price of each exhibition and the expected attendance for each artist in each exhibition. The ticket price for each exhibition is a fixed value, and the expected attendance is based on historical data and artist popularity. The gallery must ensure that no artist is overbooked and that each exhibition meets its minimum artist requirement. These operational parameters are designed to align with a linear optimization framework, ensuring that the relationships between variables are straightforward and avoid any nonlinear complexities such as variable products or divisions.

### Goals  
The primary goal of the optimization is to maximize the gallery’s total annual revenue from exhibitions. This revenue is calculated by multiplying the ticket price of each exhibition by the expected attendance for each artist in that exhibition and then summing these values across all artists and exhibitions. Success is measured by the total revenue generated, which directly depends on the strategic allocation of artists to exhibitions. The optimization process ensures that this allocation respects the constraints of artist availability and exhibition requirements, leading to a feasible and profitable solution.

## 2. Constraints  

The optimization problem is subject to the following constraints:  
1. **Artist Availability Constraint**: Each artist can participate in a limited number of exhibitions per year. The total number of exhibitions an artist is assigned to must not exceed their maximum allowed number of exhibitions.  
2. **Exhibition Requirement Constraint**: Each exhibition must have a minimum number of artists participating to ensure its success. The total number of artists assigned to an exhibition must meet or exceed this minimum requirement.  
3. **Non-Negativity Constraint**: The number of exhibitions an artist participates in must be a non-negative integer, ensuring that the solution is realistic and implementable.  

These constraints are designed to reflect real-world operational limitations and are expressed in a way that naturally leads to a linear mathematical formulation.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Schema changes include creating tables for missing optimization requirements (Ticket_Price_j and Attendance_ij). Business configuration logic updated with scalar parameters and formulas for optimization constraints and calculations.

CREATE TABLE artist_exhibition_limits (
  Artist_ID INTEGER,
  Max_Exhibitions INTEGER
);

CREATE TABLE exhibition_artist_requirements (
  Exhibition_ID INTEGER,
  Min_Artists INTEGER
);

CREATE TABLE artist_exhibition_assignments (
  Artist_ID INTEGER,
  Exhibition_ID INTEGER,
  Num_Exhibitions INTEGER
);

CREATE TABLE exhibition_ticket_prices (
  Exhibition_ID INTEGER,
  Ticket_Price INTEGER
);

CREATE TABLE artist_exhibition_attendance (
  Artist_ID INTEGER,
  Exhibition_ID INTEGER,
  Attendance INTEGER
);
```

### Data Dictionary  
- **artist_exhibition_limits**: Tracks the maximum number of exhibitions each artist can participate in.  
  - *Artist_ID*: Unique identifier for each artist.  
  - *Max_Exhibitions*: Maximum number of exhibitions the artist can participate in.  

- **exhibition_artist_requirements**: Specifies the minimum number of artists required for each exhibition.  
  - *Exhibition_ID*: Unique identifier for each exhibition.  
  - *Min_Artists*: Minimum number of artists required for the exhibition.  

- **artist_exhibition_assignments**: Records the number of exhibitions each artist participates in per year.  
  - *Artist_ID*: Unique identifier for each artist.  
  - *Exhibition_ID*: Unique identifier for each exhibition.  
  - *Num_Exhibitions*: Number of exhibitions the artist participates in.  

- **exhibition_ticket_prices**: Stores the ticket price for each exhibition.  
  - *Exhibition_ID*: Unique identifier for each exhibition.  
  - *Ticket_Price*: Ticket price for the exhibition.  

- **artist_exhibition_attendance**: Captures the expected attendance for each artist in each exhibition.  
  - *Artist_ID*: Unique identifier for each artist.  
  - *Exhibition_ID*: Unique identifier for each exhibition.  
  - *Attendance*: Expected attendance for the artist in the exhibition.  


### Retrieved Values

**Query 1: This is crucial for the Artist Availability Constraint, ensuring that no artist is overbooked.**

```sql
SELECT Artist_ID, Max_Exhibitions FROM artist_exhibition_limits;
```

**Results (CSV format):**
```csv
Artist_ID,Max_Exhibitions
1,5
2,6
3,4
```

**Query 2: This is essential for the Exhibition Requirement Constraint, ensuring each exhibition meets its minimum artist requirement.**

```sql
SELECT Exhibition_ID, Min_Artists FROM exhibition_artist_requirements;
```

**Results (CSV format):**
```csv
Exhibition_ID,Min_Artists
1,3
2,4
3,3
```

**Query 3: This helps in understanding the current allocation and ensuring it does not exceed the artist's maximum allowed exhibitions.**

```sql
SELECT Artist_ID, Exhibition_ID, Num_Exhibitions FROM artist_exhibition_assignments;
```

**Results (CSV format):**
```csv
Artist_ID,Exhibition_ID,Num_Exhibitions
1,1,1
2,2,2
3,3,1
```

**Query 4: This is a key component of the objective function, as revenue is calculated by multiplying ticket price by expected attendance.**

```sql
SELECT Exhibition_ID, Ticket_Price FROM exhibition_ticket_prices;
```

**Results (CSV format):**
```csv
Exhibition_ID,Ticket_Price
1,50
2,70
3,60
```

**Query 5: This is another key component of the objective function, as revenue is calculated by multiplying ticket price by expected attendance.**

```sql
SELECT Artist_ID, Exhibition_ID, Attendance FROM artist_exhibition_attendance;
```

**Results (CSV format):**
```csv
Artist_ID,Exhibition_ID,Attendance
1,1,100
2,2,200
3,3,150
```

**Query 6: This helps in verifying whether each exhibition meets its minimum artist requirement.**

```sql
SELECT Exhibition_ID, SUM(Num_Exhibitions) AS Total_Artists FROM artist_exhibition_assignments GROUP BY Exhibition_ID;
```

**Results (CSV format):**
```csv
Exhibition_ID,Total_Artists
1,1
2,2
3,1
```

**Query 7: This helps in verifying whether each artist is within their maximum allowed number of exhibitions.**

```sql
SELECT Artist_ID, SUM(Num_Exhibitions) AS Total_Exhibitions FROM artist_exhibition_assignments GROUP BY Artist_ID;
```

**Results (CSV format):**
```csv
Artist_ID,Total_Exhibitions
1,1
2,2
3,1
```

**Query 8: This is calculated by multiplying the ticket price by the expected attendance, providing a direct measure of revenue impact.**

```sql
SELECT a.Artist_ID, a.Exhibition_ID, a.Attendance * t.Ticket_Price AS Potential_Revenue FROM artist_exhibition_attendance a JOIN exhibition_ticket_prices t ON a.Exhibition_ID = t.Exhibition_ID;
```

**Results (CSV format):**
```csv
Artist_ID,Exhibition_ID,Potential_Revenue
1,1,5000
2,2,14000
3,3,9000
```

**Query 9: This provides a summary of the revenue impact of each exhibition, helping to prioritize high-revenue exhibitions.**

```sql
SELECT a.Exhibition_ID, SUM(a.Attendance * t.Ticket_Price) AS Total_Potential_Revenue FROM artist_exhibition_attendance a JOIN exhibition_ticket_prices t ON a.Exhibition_ID = t.Exhibition_ID GROUP BY a.Exhibition_ID;
```

**Results (CSV format):**
```csv
Exhibition_ID,Total_Potential_Revenue
1,5000
2,14000
3,9000
```

**Query 10: This provides a summary of the revenue impact of each artist, helping to prioritize high-revenue artists.**

```sql
SELECT a.Artist_ID, SUM(a.Attendance * t.Ticket_Price) AS Total_Potential_Revenue FROM artist_exhibition_attendance a JOIN exhibition_ticket_prices t ON a.Exhibition_ID = t.Exhibition_ID GROUP BY a.Artist_ID;
```

**Results (CSV format):**
```csv
Artist_ID,Total_Potential_Revenue
1,5000
2,14000
3,9000
```

