# Complete Optimization Problem and Solution: wedding

## 1. Problem Context and Goals

### Context  
A wedding planning company is tasked with organizing weddings across multiple churches each year. The company aims to minimize the total cost of these weddings while ensuring that each church operates within its capacity and that the total number of weddings per year does not exceed a predefined limit. The key decision involves determining the number of weddings to hold at each church each year, considering the cost of organizing a wedding at each church and the operational constraints.

The cost of organizing a wedding varies by church and year, and these costs are known and fixed. Each church has a maximum capacity for the number of weddings it can handle annually, ensuring that the quality of service is maintained. Additionally, there is a company-wide limit on the total number of weddings that can be organized each year, reflecting the overall operational capacity.

The business configuration includes two critical parameters: the maximum number of weddings allowed per year, which is set to 120, and the maximum number of weddings a single church can handle, which is set to 30. These parameters ensure that the company operates within realistic and sustainable limits.

### Goals  
The primary goal of the optimization is to minimize the total cost of organizing weddings across all churches and years. This is achieved by strategically deciding how many weddings to hold at each church each year, considering the cost per wedding at each location and the operational constraints. Success is measured by achieving the lowest possible total cost while adhering to the capacity limits of each church and the overall annual limit on weddings.

## 2. Constraints    

The optimization problem is subject to two main constraints:

1. **Annual Wedding Limit**: The total number of weddings organized across all churches in a given year must not exceed the maximum number of weddings allowed per year, which is 120. This ensures that the company does not overextend its operational capacity in any single year.

2. **Church Capacity Limit**: The number of weddings held at each church in a given year must not exceed the maximum number of weddings that the church can handle, which is 30. This ensures that each church operates within its capacity, maintaining the quality of service for each wedding.

These constraints ensure that the company operates within realistic and sustainable limits while minimizing costs.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating tables for cost per wedding, church capacity, and maximum weddings per year. Business configuration logic updated with scalar parameters and formulas for optimization.

CREATE TABLE cost_per_wedding (
  church_id INTEGER,
  year INTEGER,
  cost FLOAT
);

CREATE TABLE weddings (
  church_id INTEGER,
  year INTEGER,
  number_of_weddings INTEGER
);
```

### Data Dictionary  
- **cost_per_wedding**: This table contains the cost of organizing a wedding at a specific church in a specific year. The cost is used as a coefficient in the objective function to calculate the total cost of weddings.
  - **church_id**: Unique identifier for the church.
  - **year**: Year of the wedding.
  - **cost**: Cost of organizing a wedding at the specified church and year.

- **weddings**: This table contains the number of weddings held at each church each year. This data represents the decision variables in the optimization model.
  - **church_id**: Unique identifier for the church.
  - **year**: Year of the wedding.
  - **number_of_weddings**: Number of weddings held at the specified church and year.


### Retrieved Values

**Query 1: Query Description: Retrieve the cost per wedding for each church and year. This data is crucial for the objective function, as it provides the coefficients needed to calculate the total cost of weddings.**

```sql
SELECT church_id, year, cost FROM cost_per_wedding;
```

**Results (CSV format):**
```csv
church_id,year,cost
1,2023,5000.0
2,2023,4500.0
3,2023,6000.0
1,2024,5200.0
2,2024,4600.0
3,2024,6100.0
```

**Query 2: Query Description: Retrieve the number of weddings held at each church each year. This data represents the decision variables in the optimization model, which need to be optimized to minimize total cost.**

```sql
SELECT church_id, year, number_of_weddings FROM weddings;
```

**Results (CSV format):**
```csv
church_id,year,number_of_weddings
1,2023,10
2,2023,15
3,2023,8
1,2024,12
2,2024,16
3,2024,9
```

**Query 3: Query Description: Calculate the total number of weddings per year across all churches. This is important for the annual wedding limit constraint, ensuring that the total number of weddings does not exceed 120.**

```sql
SELECT year, SUM(number_of_weddings) AS total_weddings FROM weddings GROUP BY year;
```

**Results (CSV format):**
```csv
year,total_weddings
2023,33
2024,37
```

**Query 4: Query Description: Calculate the total number of weddings per church per year. This is important for the church capacity limit constraint, ensuring that no church exceeds its maximum capacity of 30 weddings per year.**

```sql
SELECT church_id, year, SUM(number_of_weddings) AS church_weddings FROM weddings GROUP BY church_id, year;
```

**Results (CSV format):**
```csv
church_id,year,church_weddings
1,2023,10
1,2024,12
2,2023,15
2,2024,16
3,2023,8
3,2024,9
```

**Query 5: Query Description: Retrieve the total cost of weddings per year across all churches. This aggregated data helps in understanding the overall cost structure and verifying the optimization results.**

```sql
SELECT w.year, SUM(w.number_of_weddings * c.cost) AS total_cost FROM weddings w JOIN cost_per_wedding c ON w.church_id = c.church_id AND w.year = c.year GROUP BY w.year;
```

**Results (CSV format):**
```csv
year,total_cost
2023,165500.0
2024,190900.0
```

**Query 6: Query Description: Retrieve the total cost of weddings per church per year. This detailed cost breakdown helps in identifying which churches contribute most to the total cost and where cost savings can be achieved.**

```sql
SELECT w.church_id, w.year, SUM(w.number_of_weddings * c.cost) AS church_cost FROM weddings w JOIN cost_per_wedding c ON w.church_id = c.church_id AND w.year = c.year GROUP BY w.church_id, w.year;
```

**Results (CSV format):**
```csv
church_id,year,church_cost
1,2023,50000.0
1,2024,62400.0
2,2023,67500.0
2,2024,73600.0
3,2023,48000.0
3,2024,54900.0
```

**Query 7: Query Description: Retrieve the maximum number of weddings per church per year. This data is essential for the church capacity limit constraint, ensuring that no church exceeds its maximum capacity of 30 weddings per year.**

```sql
SELECT church_id, year, MAX(number_of_weddings) AS max_weddings FROM weddings GROUP BY church_id, year;
```

**Results (CSV format):**
```csv
church_id,year,max_weddings
1,2023,10
1,2024,12
2,2023,15
2,2024,16
3,2023,8
3,2024,9
```

**Query 8: Query Description: Retrieve the total number of weddings per church across all years. This summary statistic helps in understanding the overall utilization of each church and identifying potential bottlenecks.**

```sql
SELECT church_id, SUM(number_of_weddings) AS total_weddings FROM weddings GROUP BY church_id;
```

**Results (CSV format):**
```csv
church_id,total_weddings
1,22
2,31
3,17
```

**Query 9: Query Description: Retrieve the total number of weddings per year across all churches. This summary statistic helps in understanding the overall annual workload and ensuring it does not exceed the annual limit of 120 weddings.**

```sql
SELECT year, SUM(number_of_weddings) AS total_weddings FROM weddings GROUP BY year;
```

**Results (CSV format):**
```csv
year,total_weddings
2023,33
2024,37
```

**Query 10: Query Description: Retrieve the total cost of weddings across all churches and years. This overall cost metric is the primary objective to minimize in the optimization problem.**

```sql
SELECT SUM(w.number_of_weddings * c.cost) AS total_cost FROM weddings w JOIN cost_per_wedding c ON w.church_id = c.church_id AND w.year = c.year;
```

**Results (CSV format):**
```csv
total_cost
356400.0
```

