# Complete Optimization Problem and Solution: activity_1

## 1. Problem Context and Goals

### Context  
A university is managing the allocation of students and faculty to extracurricular activities with the goal of maximizing overall participation. The decision-making process involves determining which students and faculty members should participate in which activities. Each student can participate in at most one activity, and each faculty member can participate in at most two activities. Additionally, each activity has a predefined maximum number of participants that cannot be exceeded.  

The business configuration includes the following operational parameters:  
- **Faculty Availability Limit**: Faculty members are limited to participating in a maximum of two activities to balance their workload and ensure availability.  
- **Student Preference Threshold**: Students are allowed to participate in only one activity to ensure focused engagement and avoid overcommitment.  
- **Total Participation Calculation**: The total participation in an activity is calculated as the sum of student and faculty participation in that activity.  

The optimization problem is designed to ensure that these constraints are respected while maximizing the total number of participants across all activities.  

### Goals  
The primary goal of this optimization problem is to maximize the total participation in extracurricular activities by both students and faculty. Success is measured by the total number of participants across all activities, which is the sum of student and faculty participation. This goal aligns with the operational parameters and ensures that the allocation respects the constraints on faculty availability, student preferences, and activity capacity limits.  

## 2. Constraints  

The optimization problem must adhere to the following constraints:  
1. **Student Participation Limit**: Each student can participate in at most one activity. This ensures that students are not overcommitted and can focus on their chosen activity.  
2. **Faculty Participation Limit**: Each faculty member can participate in at most two activities. This constraint balances faculty workload and ensures their availability across activities.  
3. **Activity Capacity Limit**: The total number of participants in each activity, including both students and faculty, must not exceed the predefined maximum capacity for that activity. This ensures that activities are not overcrowded and can operate effectively.  

These constraints are designed to ensure that the allocation of participants is feasible and aligns with the operational capabilities of the university.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Added Activity_Capacity table to address missing max_participants constraint. Updated business_configuration_logic.json with scalar parameters and formulas. Ensured schema follows normalization principles and industry standards.

CREATE TABLE Participates_in (
  stuid INTEGER,
  actid INTEGER
);

CREATE TABLE Faculty_Participates_in (
  FacID INTEGER,
  actid INTEGER
);

CREATE TABLE Activity_Capacity (
  actid INTEGER,
  max_participants INTEGER
);
```

### Data Dictionary  
- **Participates_in**: Tracks student participation in activities.  
  - **stuid**: Unique identifier for a student. Used to determine which students participate in which activities.  
  - **actid**: Unique identifier for an activity. Used to link students to specific activities.  
- **Faculty_Participates_in**: Tracks faculty participation in activities.  
  - **FacID**: Unique identifier for a faculty member. Used to determine which faculty members participate in which activities.  
  - **actid**: Unique identifier for an activity. Used to link faculty members to specific activities.  
- **Activity_Capacity**: Defines the maximum number of participants allowed in each activity.  
  - **actid**: Unique identifier for an activity. Used to link capacity limits to specific activities.  
  - **max_participants**: The maximum number of participants allowed in the activity. Used to enforce capacity constraints.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical university extracurricular activity participation rates, faculty workload considerations, and activity capacity limits. The data ensures that the optimization problem is meaningful and solvable by respecting constraints and business logic.

-- Realistic data for Participates_in
INSERT INTO Participates_in (stuid, actid) VALUES (101, 1);
INSERT INTO Participates_in (stuid, actid) VALUES (102, 2);
INSERT INTO Participates_in (stuid, actid) VALUES (103, 3);

-- Realistic data for Faculty_Participates_in
INSERT INTO Faculty_Participates_in (FacID, actid) VALUES (201, 1);
INSERT INTO Faculty_Participates_in (FacID, actid) VALUES (202, 2);
INSERT INTO Faculty_Participates_in (FacID, actid) VALUES (203, 3);

-- Realistic data for Activity_Capacity
INSERT INTO Activity_Capacity (actid, max_participants) VALUES (1, 10);
INSERT INTO Activity_Capacity (actid, max_participants) VALUES (2, 15);
INSERT INTO Activity_Capacity (actid, max_participants) VALUES (3, 20);
```