# Complete Optimization Problem and Solution: aircraft

## 1. Problem Context and Goals

### Context  
The business problem involves optimizing the assignment of aircraft to airports to minimize total operational costs while ensuring that each airport's passenger demand is met and aircraft capacity constraints are respected. The decision to be made is the number of each type of aircraft assigned to each airport, which directly impacts operational costs. Each aircraft type has a specific passenger capacity, and each airport has a defined passenger demand and a maximum number of aircraft movements it can handle. The operational cost of assigning a specific aircraft type to a particular airport is known and varies based on the aircraft and airport combination. The business configuration includes a maximum number of aircraft movements allowed at each airport, which ensures that the airport's movement capacity is not exceeded. The total operational cost is calculated as the sum of the costs of all aircraft assignments, where each cost is the product of the operational cost for a specific aircraft-airport pair and the number of aircraft assigned to that pair.

### Goals  
The primary goal of this optimization is to minimize the total operational costs associated with assigning aircraft to airports. Success is measured by achieving the lowest possible sum of operational costs across all aircraft assignments while ensuring that all airports meet their passenger demand and do not exceed their aircraft movement capacity. The optimization focuses on making precise operational decisions that lead to a linear formulation, avoiding any scenarios that would require nonlinear relationships such as variable products or divisions.

## 2. Constraints    

The optimization must adhere to the following constraints:  
1. **Passenger Demand Constraint**: For each airport, the total passenger capacity of all assigned aircraft must meet or exceed the airport's passenger demand. This ensures that the airport can accommodate all passengers.  
2. **Aircraft Movement Constraint**: For each airport, the total number of assigned aircraft must not exceed the airport's maximum number of aircraft movements. This ensures that the airport's movement capacity is not exceeded.  

These constraints are designed to ensure that the optimization respects both passenger demand and operational capacity limitations, leading to a feasible and realistic solution.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating tables for operational costs and aircraft capacities, modifying the airport table to better align with constraints, and adding configuration logic for scalar parameters and formulas.

CREATE TABLE aircraft_capacity (
  aircraft_type STRING,
  passenger_capacity INTEGER
);

CREATE TABLE operational_costs (
  aircraft_type STRING,
  airport_code STRING,
  cost FLOAT,
  aircraft_count INTEGER
);

CREATE TABLE airport (
  airport_code STRING,
  passenger_demand INTEGER,
  aircraft_movements INTEGER
);
```

### Data Dictionary  
- **aircraft_capacity**:  
  - **aircraft_type**: Identifies the type of aircraft.  
  - **passenger_capacity**: Represents the maximum number of passengers the aircraft can carry, used to ensure passenger demand is met.  

- **operational_costs**:  
  - **aircraft_type**: Identifies the type of aircraft.  
  - **airport_code**: Identifies the airport.  
  - **cost**: Represents the operational cost of assigning the aircraft to the airport, used in the objective function.  
  - **aircraft_count**: Represents the number of aircraft assigned, which is the decision variable in the optimization.  

- **airport**:  
  - **airport_code**: Identifies the airport.  
  - **passenger_demand**: Represents the total passenger demand at the airport, used in the passenger demand constraint.  
  - **aircraft_movements**: Represents the maximum number of aircraft movements at the airport, used in the aircraft movement constraint.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on industry standards, realistic operational costs, and typical airport and aircraft capacities. Relationships between tables were considered to ensure data consistency and optimization solvability.

-- Realistic data for aircraft_capacity
INSERT INTO aircraft_capacity (aircraft_type, passenger_capacity) VALUES ('Boeing 737', 150);
INSERT INTO aircraft_capacity (aircraft_type, passenger_capacity) VALUES ('Airbus A320', 180);
INSERT INTO aircraft_capacity (aircraft_type, passenger_capacity) VALUES ('Boeing 777', 300);

-- Realistic data for operational_costs
INSERT INTO operational_costs (aircraft_type, airport_code, cost, aircraft_count) VALUES ('Boeing 737', 'JFK', 5000.0, 0);
INSERT INTO operational_costs (aircraft_type, airport_code, cost, aircraft_count) VALUES ('Airbus A320', 'JFK', 5500.0, 0);
INSERT INTO operational_costs (aircraft_type, airport_code, cost, aircraft_count) VALUES ('Boeing 777', 'JFK', 8000.0, 0);
INSERT INTO operational_costs (aircraft_type, airport_code, cost, aircraft_count) VALUES ('Boeing 737', 'LAX', 4800.0, 0);
INSERT INTO operational_costs (aircraft_type, airport_code, cost, aircraft_count) VALUES ('Airbus A320', 'LAX', 5200.0, 0);

-- Realistic data for airport
INSERT INTO airport (airport_code, passenger_demand, aircraft_movements) VALUES ('JFK', 15000, 50);
INSERT INTO airport (airport_code, passenger_demand, aircraft_movements) VALUES ('LAX', 20000, 60);
INSERT INTO airport (airport_code, passenger_demand, aircraft_movements) VALUES ('ORD', 18000, 55);
```