# Complete Optimization Problem and Solution: body_builder

## 1. Problem Context and Goals

### Context  
A bodybuilding competition organizer is tasked with selecting a team of bodybuilders to compete in an upcoming event. The goal is to assemble a team that maximizes the total performance score based on the bodybuilders' Snatch and Clean & Jerk scores. The selection process must adhere to specific operational constraints to ensure the team meets diversity and physical criteria.  

The organizer must decide which bodybuilders to include in the team, represented by a binary decision for each individual. The total number of bodybuilders in the team cannot exceed a predefined limit, ensuring the team remains manageable and diverse. Additionally, the team must meet a minimum average height requirement of 170 cm and a maximum average weight requirement of 100 kg. These constraints ensure the team aligns with the competition's physical standards.  

The performance scores for each bodybuilder are derived from their Snatch and Clean & Jerk results, which are stored in the database. The physical attributes of height and weight are also recorded and used to enforce the team's physical criteria. The business configuration includes a maximum team size limit of 5 bodybuilders, a minimum average height requirement, and a maximum average weight requirement, all of which are critical to the selection process.  

### Goals  
The primary goal of this optimization problem is to maximize the total performance score of the selected team. This score is calculated as the sum of the Snatch and Clean & Jerk scores of the chosen bodybuilders. Success is measured by achieving the highest possible total score while adhering to the constraints on team size, average height, and average weight.  

## 2. Constraints  

The selection of bodybuilders for the team must respect the following constraints:  
1. **Team Size Limit**: The total number of bodybuilders selected for the team must not exceed the predefined limit of 5. This ensures the team remains manageable and diverse.  
2. **Minimum Average Height**: The average height of the selected bodybuilders must be at least 170 cm. This ensures the team meets the competition's physical standards for height.  
3. **Maximum Average Weight**: The average weight of the selected bodybuilders must not exceed 100 kg. This ensures the team aligns with the competition's physical standards for weight.  

These constraints are designed to ensure the team is both competitive and compliant with the competition's requirements.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include adding a table for decision variables and updating configuration logic to handle team size constraints and business metrics.

CREATE TABLE body_builder (
  Snatch FLOAT,
  Clean_Jerk FLOAT
);

CREATE TABLE people (
  Height FLOAT,
  Weight FLOAT
);

CREATE TABLE team_selection (
  is_selected BOOLEAN
);
```

### Data Dictionary  
- **body_builder Table**:  
  - **Snatch**: The Snatch score of a bodybuilder, used to calculate the total performance score.  
  - **Clean_Jerk**: The Clean & Jerk score of a bodybuilder, used to calculate the total performance score.  

- **people Table**:  
  - **Height**: The height of a bodybuilder in centimeters, used to enforce the minimum average height constraint.  
  - **Weight**: The weight of a bodybuilder in kilograms, used to enforce the maximum average weight constraint.  

- **team_selection Table**:  
  - **is_selected**: A binary indicator of whether a bodybuilder is selected for the team, representing the decision variable in the optimization model.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical bodybuilding competition data, ensuring realistic performance scores and physical attributes. The data was generated to respect the constraints and enable a meaningful optimization problem.

-- Realistic data for body_builder
INSERT INTO body_builder (Snatch, Clean_Jerk) VALUES (150.5, 200.0);
INSERT INTO body_builder (Snatch, Clean_Jerk) VALUES (160.0, 210.5);
INSERT INTO body_builder (Snatch, Clean_Jerk) VALUES (170.5, 220.0);

-- Realistic data for people
INSERT INTO people (Height, Weight) VALUES (175.0, 90.0);
INSERT INTO people (Height, Weight) VALUES (180.0, 95.0);
INSERT INTO people (Height, Weight) VALUES (185.0, 100.0);

-- Realistic data for team_selection
INSERT INTO team_selection (is_selected) VALUES (True);
INSERT INTO team_selection (is_selected) VALUES (False);
INSERT INTO team_selection (is_selected) VALUES (True);
```