# Complete Optimization Problem and Solution: cinema

## 1. Problem Context and Goals

### Context  
A cinema chain is focused on maximizing its revenue by optimizing the scheduling of films across its cinemas. The key decision involves determining the number of showings per film per cinema per day, which directly impacts revenue. The cinema operates under specific operational parameters, including the price per showing, the capacity of each cinema, and the maximum number of showings allowed per day per cinema. These parameters are critical in ensuring that the scheduling aligns with both business goals and operational constraints.

The business configuration includes two key scalar parameters:  
1. **Maximum number of showings allowed per day per cinema**: This parameter ensures that the total number of showings per day does not exceed a realistic limit, which is set to 12 based on typical cinema operating hours.  
2. **Total capacity of the cinema per day**: This parameter ensures that the total number of seats available across all showings in a day does not exceed the cinema's daily capacity, which is calculated based on the cinema's seating capacity and the maximum number of showings.

The optimization problem is designed to maximize revenue by leveraging these parameters in a linear manner, ensuring that the relationships between decision variables and constraints remain straightforward and avoid any nonlinear complexities.

### Goals  
The primary goal of this optimization problem is to maximize the total revenue generated from film showings across all cinemas. Revenue is calculated by multiplying the price per showing, the number of showings per film per cinema per day, and the capacity of the cinema. Success is measured by achieving the highest possible revenue while adhering to the operational constraints, such as the maximum number of showings and the total capacity of the cinema. The optimization process ensures that these goals are met through a linear formulation, avoiding any nonlinear relationships that could complicate the decision-making process.

## 2. Constraints  

The optimization problem is subject to the following constraints, which are designed to reflect realistic operational limitations:  
1. **Maximum showings per day per cinema**: The total number of showings per day in a cinema cannot exceed the maximum allowed, which is set to 12. This ensures that the cinema's operating hours are not overextended.  
2. **Total capacity per day**: The total number of seats available across all showings in a day must not exceed the cinema's daily capacity. This ensures that the cinema does not overbook its available seating.  
3. **Minimum showings per film**: Each film must be shown at least once per day in each cinema. This ensures that all films receive adequate exposure and that the cinema's schedule remains balanced.  

These constraints are designed to align with the linear nature of the optimization problem, ensuring that the relationships between decision variables and constraints remain straightforward and avoid any nonlinear complexities.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include adding tables for missing constraints and updating configuration logic to handle scalar parameters and formulas. Business configuration logic now includes maximum show times and total capacity per day.

CREATE TABLE schedule (
  Price FLOAT,
  Show_times_per_day INTEGER
);

CREATE TABLE cinema (
  Capacity INTEGER
);
```

### Data Dictionary  
The data dictionary provides a clear mapping of the tables and columns to their business purposes and optimization roles:  
- **schedule**: This table stores information about film showings, including the price per showing and the number of showings per film per cinema per day.  
  - **Price**: Represents the price per showing of a film. This value is used as a coefficient in the revenue calculation.  
  - **Show_times_per_day**: Represents the number of showings per film per cinema per day. This is the primary decision variable in the optimization problem.  
- **cinema**: This table stores information about cinemas, including their seating capacity.  
  - **Capacity**: Represents the seating capacity of the cinema. This value is used as a coefficient in the revenue calculation.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on industry standards, typical cinema operations, and ensuring the optimization problem remains solvable. Cinema capacities and show times were aligned with real-world scenarios, while prices were set to reflect average ticket costs.

-- Realistic data for schedule
INSERT INTO schedule (Price, Show_times_per_day) VALUES (12.99, 3);
INSERT INTO schedule (Price, Show_times_per_day) VALUES (9.99, 2);
INSERT INTO schedule (Price, Show_times_per_day) VALUES (7.99, 1);

-- Realistic data for cinema
INSERT INTO cinema (Capacity) VALUES (150);
INSERT INTO cinema (Capacity) VALUES (200);
INSERT INTO cinema (Capacity) VALUES (100);
```