# Complete Optimization Problem and Solution: club_1

## 1. Problem Context and Goals

### Context  
The problem revolves around optimizing the allocation of students to clubs to maximize overall student engagement. Each student can be assigned to at most one club, and each club has a maximum capacity that cannot be exceeded. The engagement score for a student in a club is calculated as a weighted combination of their participation level and the importance of the club. This score is used to measure the effectiveness of the assignment. The default maximum number of students allowed in a club is set to 20, ensuring a realistic starting point for capacity constraints. The engagement score formula, which combines participation and club importance, is used to compute the coefficients for the optimization objective. The decision variables are binary, indicating whether a student is assigned to a specific club. The goal is to make these assignments in a way that maximizes the total engagement score across all students and clubs, while respecting the capacity limits of each club and ensuring each student is assigned to no more than one club.

### Goals  
The primary goal of this optimization problem is to maximize the total engagement score of students in their assigned clubs. This is achieved by assigning students to clubs in a way that leverages their individual engagement scores, which are derived from their participation levels and the importance of the clubs. Success is measured by the sum of these engagement scores, ensuring that the assignments are both effective and efficient. The optimization process ensures that the total engagement score is as high as possible, while adhering to the constraints of club capacities and student assignment limits.

## 2. Constraints    

The optimization problem is subject to two key constraints:  
1. **Club Capacity Constraint**: The total number of students assigned to any club must not exceed the club's maximum capacity. This ensures that clubs do not become overcrowded and can operate effectively within their defined limits.  
2. **Student Assignment Constraint**: Each student can be assigned to at most one club. This ensures that students are not overcommitted and can fully engage with their chosen club.  

These constraints are designed to reflect real-world operational limitations and ensure that the optimization solution is both practical and feasible.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating tables for engagement scores and club capacities, and updating configuration logic for scalar parameters and formulas.

CREATE TABLE Engagement_Scores (
  StuID INTEGER,
  ClubID INTEGER,
  score FLOAT
);

CREATE TABLE Club_Capacities (
  ClubID INTEGER,
  capacity INTEGER
);

CREATE TABLE Member_of_club (
  StuID INTEGER,
  ClubID INTEGER
);
```

### Data Dictionary  
- **Engagement_Scores**:  
  - **Purpose**: Stores the engagement scores for each student-club pair.  
  - **Columns**:  
    - **StuID**: Identifies the student.  
    - **ClubID**: Identifies the club.  
    - **score**: Represents the engagement score of the student in the club, used as a coefficient in the objective function.  

- **Club_Capacities**:  
  - **Purpose**: Stores the maximum number of students allowed in each club.  
  - **Columns**:  
    - **ClubID**: Identifies the club.  
    - **capacity**: Represents the maximum number of students allowed in the club, used as a bound in the capacity constraint.  

- **Member_of_club**:  
  - **Purpose**: Stores which students are members of which clubs.  
  - **Columns**:  
    - **StuID**: Identifies the student.  
    - **ClubID**: Identifies the club.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic club sizes, student engagement levels, and the need to ensure a solvable optimization problem. Club capacities were set to reflect typical club sizes, while engagement scores were calculated using the provided formula, considering varying levels of student participation and club importance.

-- Realistic data for Engagement_Scores
INSERT INTO Engagement_Scores (StuID, ClubID, score) VALUES (1, 101, 0.6);
INSERT INTO Engagement_Scores (StuID, ClubID, score) VALUES (2, 102, 0.8);
INSERT INTO Engagement_Scores (StuID, ClubID, score) VALUES (3, 103, 0.4);

-- Realistic data for Club_Capacities
INSERT INTO Club_Capacities (ClubID, capacity) VALUES (101, 20);
INSERT INTO Club_Capacities (ClubID, capacity) VALUES (102, 25);
INSERT INTO Club_Capacities (ClubID, capacity) VALUES (103, 15);

-- Realistic data for Member_of_club
INSERT INTO Member_of_club (StuID, ClubID) VALUES (1, 101);
INSERT INTO Member_of_club (StuID, ClubID) VALUES (2, 102);
INSERT INTO Member_of_club (StuID, ClubID) VALUES (3, 103);
```