# Complete Optimization Problem and Solution: coffee_shop

## 1. Problem Context and Goals

### Context  
A coffee shop chain is focused on optimizing staff allocation during happy hours across its various shops. The goal is to maximize customer satisfaction by ensuring that members, who are valued based on their membership level, spend more during these peak hours. The chain must allocate staff efficiently to meet customer demand while staying within operational constraints. 

The key decision involves determining the number of staff to assign to each shop during happy hours. This decision must consider the total budget for staff across all shops, which is capped at 150. Additionally, each shop has specific staffing limits: a minimum of 2 staff members is required to maintain basic operations, and a maximum of 15 staff members is allowed to handle peak customer traffic. The chain also enforces a maximum spending limit of $50 per member to control costs while encouraging customer spending.

The optimization problem is designed to maximize the total amount spent by members during happy hours, weighted by their membership level. This ensures that higher-tier members, who contribute more to revenue, are prioritized. The problem is structured to ensure that all constraints are linear, avoiding any nonlinear relationships such as variable products or divisions.

### Goals  
The primary goal of this optimization is to maximize the total weighted spending by members during happy hours. This is achieved by assigning the optimal number of staff to each shop, ensuring that higher-tier members are adequately served. Success is measured by the total amount spent by members, adjusted for their membership level, while adhering to the total staff budget and individual shop staffing limits. The optimization ensures that the chain operates efficiently, balancing customer satisfaction with operational costs.

## 2. Constraints  

The optimization problem is subject to the following constraints:  
1. **Total Staff Budget Constraint**: The total number of staff assigned across all shops must not exceed the total budget of 150. This ensures that the chain operates within its financial limits.  
2. **Shop Staffing Limits**: Each shop must have a minimum of 2 staff members to maintain basic operations and a maximum of 15 staff members to handle peak customer traffic. This ensures that each shop is adequately staffed without exceeding its capacity.  
3. **Maximum Spending Limit per Member**: The spending per member during happy hours must not exceed $50. This constraint helps control costs while encouraging customer spending.  

These constraints are designed to ensure that the optimization problem remains linear, avoiding any nonlinear relationships that could complicate the solution.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for missing constraint bounds, modifying existing tables to refine decision variable mapping, and adding business configuration logic for scalar parameters and formulas.

CREATE TABLE happy_hour_member (
  Total_amount FLOAT
);

CREATE TABLE member (
  Level_of_membership INTEGER
);

CREATE TABLE happy_hour (
  Num_of_staff_in_charge INTEGER
);

CREATE TABLE shop_staff_limits (
  Max_Staff_Per_Shop INTEGER,
  Min_Staff_Per_Shop INTEGER
);
```

### Data Dictionary  
- **happy_hour_member**:  
  - **Business Purpose**: Records the amount spent by each member during happy hours.  
  - **Optimization Role**: Provides coefficients for the objective function.  
  - **Columns**:  
    - **Total_amount**: The amount spent by a member during a happy hour.  

- **member**:  
  - **Business Purpose**: Stores membership information for each member.  
  - **Optimization Role**: Provides coefficients for the objective function.  
  - **Columns**:  
    - **Level_of_membership**: The membership level of a member, used to weight their spending in the objective function.  

- **happy_hour**:  
  - **Business Purpose**: Records the number of staff assigned to each shop during happy hours.  
  - **Optimization Role**: Represents the decision variable in the optimization model.  
  - **Columns**:  
    - **Num_of_staff_in_charge**: The number of staff assigned to a shop during a happy hour.  

- **shop_staff_limits**:  
  - **Business Purpose**: Stores the maximum and minimum number of staff allowed per shop.  
  - **Optimization Role**: Provides constraint bounds for the optimization model.  
  - **Columns**:  
    - **Max_Staff_Per_Shop**: The maximum number of staff allowed per shop.  
    - **Min_Staff_Per_Shop**: The minimum number of staff required per shop.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical coffee shop operations, considering factors like average spending, staff requirements, and membership levels. Data was generated to ensure a balance between customer satisfaction and operational costs.

-- Realistic data for happy_hour_member
INSERT INTO happy_hour_member (Total_amount) VALUES (25.5);
INSERT INTO happy_hour_member (Total_amount) VALUES (30.0);
INSERT INTO happy_hour_member (Total_amount) VALUES (15.75);

-- Realistic data for member
INSERT INTO member (Level_of_membership) VALUES (1);
INSERT INTO member (Level_of_membership) VALUES (2);
INSERT INTO member (Level_of_membership) VALUES (3);

-- Realistic data for happy_hour
INSERT INTO happy_hour (Num_of_staff_in_charge) VALUES (3);
INSERT INTO happy_hour (Num_of_staff_in_charge) VALUES (5);
INSERT INTO happy_hour (Num_of_staff_in_charge) VALUES (7);

-- Realistic data for shop_staff_limits
INSERT INTO shop_staff_limits (Max_Staff_Per_Shop, Min_Staff_Per_Shop) VALUES (10, 2);
INSERT INTO shop_staff_limits (Max_Staff_Per_Shop, Min_Staff_Per_Shop) VALUES (12, 3);
INSERT INTO shop_staff_limits (Max_Staff_Per_Shop, Min_Staff_Per_Shop) VALUES (15, 4);
```