# Complete DOCPLEX implementation - Retry Attempt 1

from docplex.mp.model import Model

def optimize_employee_assignment():
    # 1. MODEL & DATA SETUP
    mdl = Model(name="employee_assignment_optimization")
    
    # Example data (replace with actual data from your database)
    employees = [1, 2, 3]
    companies = [1, 2, 3]
    experience = {1: 5, 2: 10, 3: 15}  # Years of experience for each employee
    profit = {1: 100000, 2: 150000, 3: 200000}  # Profit for each company
    max_employees = {1: 10, 2: 15, 3: 20}  # Maximum employees each company can hire
    
    # Weights
    weight_experience = 0.7
    weight_profit = 0.3
    
    # 2. VARIABLES
    x = {(i, j): mdl.binary_var(name=f"x_{i}_{j}") for i in employees for j in companies}
    
    # 3. OBJECTIVE FUNCTION
    objective = mdl.sum((weight_experience * experience[i] + weight_profit * profit[j]) * x[i, j] 
                        for i in employees for j in companies)
    mdl.maximize(objective)
    
    # 4. CONSTRAINTS
    
    # Employee Assignment Constraint: Each employee must be assigned to exactly one company
    for i in employees:
        mdl.add_constraint(mdl.sum(x[i, j] for j in companies) == 1, ctname=f"employee_assignment_{i}")
    
    # Company Capacity Constraint: The total number of employees assigned to each company cannot exceed its maximum capacity
    for j in companies:
        mdl.add_constraint(mdl.sum(x[i, j] for i in employees) <= max_employees[j], ctname=f"company_capacity_{j}")
    
    # 5. SOLVING & RESULTS
    solution = mdl.solve()
    
    if solution:
        print(f"Optimal value: {solution.objective_value}")
        for i in employees:
            for j in companies:
                if solution.get_value(x[i, j]) > 0.5:
                    print(f"Employee {i} assigned to Company {j}")
    else:
        print("No solution found")
        print(f"Status: {mdl.solve_details.status}")
    
    return mdl

# Execute the optimization
optimize_employee_assignment()