# Complete Optimization Problem and Solution: company_office

## 1. Problem Context and Goals

### Context  
The company is focused on optimizing the allocation of office spaces across multiple buildings to minimize the total leasing cost. The decision involves determining the amount of space to allocate to each company in each building, ensuring that each company's space requirements are met based on their sales and assets. The cost per square foot for leasing space varies by building, and the total available space in each building is limited. The goal is to allocate space in a way that minimizes the overall leasing cost while adhering to these constraints.

Key operational parameters include:
- **Cost per square foot for leasing space in each building**: This is used to calculate the total leasing cost, which is the primary metric to minimize.
- **Minimum space required by each company**: This ensures that each company receives enough space to meet its operational needs based on its sales and assets.
- **Total available space in each building**: This ensures that the total space allocated in each building does not exceed its capacity.

The total leasing cost is calculated by summing the product of the cost per square foot for each building and the space allocated to each company in that building. This calculation is linear and directly tied to the decision variables, ensuring a straightforward optimization formulation.

### Goals  
The primary goal of this optimization problem is to minimize the total leasing cost of office spaces across all buildings. This is achieved by determining the optimal allocation of space to each company in each building, considering the cost per square foot for each building and the space requirements of each company. Success is measured by achieving the lowest possible total leasing cost while ensuring that all companies receive their required space and that no building exceeds its available space capacity.

## 2. Constraints    

The optimization problem is subject to the following constraints:
1. **Minimum Space Requirement**: The total space allocated to each company across all buildings must meet or exceed the company's minimum space requirement. This ensures that each company has enough space to operate effectively based on its sales and assets.
2. **Building Capacity**: The total space allocated in each building must not exceed the building's available space. This ensures that the physical limitations of each building are respected.
3. **Non-Negative Allocation**: The space allocated to each company in each building must be non-negative. This ensures that the allocation is physically meaningful and feasible.

These constraints are linear and directly tied to the decision variables, ensuring that the optimization problem remains linear and tractable.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Added space_allocated table to map decision variables, updated business configuration logic with scalar parameters and formulas, and ensured schema follows normalization principles.

CREATE TABLE cost_per_sqft (
  building_id INTEGER,
  cost_per_sqft FLOAT
);

CREATE TABLE required_space (
  company_id INTEGER,
  required_space INTEGER
);

CREATE TABLE available_space (
  building_id INTEGER,
  available_space INTEGER
);

CREATE TABLE space_allocated (
  building_id INTEGER,
  company_id INTEGER,
  space_allocated FLOAT
);
```

### Data Dictionary  
- **cost_per_sqft**: This table contains the cost per square foot for leasing space in each building. It is used to calculate the total leasing cost in the objective function.
  - **building_id**: Unique identifier for each building.
  - **cost_per_sqft**: Cost per square foot for leasing space in the building.
  
- **required_space**: This table contains the minimum space required by each company based on their sales and assets. It is used to ensure that each company's space requirements are met in the constraints.
  - **company_id**: Unique identifier for each company.
  - **required_space**: Minimum space required by the company.
  
- **available_space**: This table contains the total available space in each building. It is used to ensure that the total space allocated in each building does not exceed its capacity in the constraints.
  - **building_id**: Unique identifier for each building.
  - **available_space**: Total available space in the building.
  
- **space_allocated**: This table contains the amount of space allocated to each company in each building. It represents the decision variables in the optimization problem.
  - **building_id**: Unique identifier for each building.
  - **company_id**: Unique identifier for each company.
  - **space_allocated**: Amount of space allocated to the company in the building.

### Current Stored Values  
```sql
-- Iteration 2 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic business scenarios, considering typical office space costs, company space requirements, and building capacities. Data was generated to ensure a balanced optimization problem with feasible constraints.

-- Realistic data for cost_per_sqft
INSERT INTO cost_per_sqft (building_id, cost_per_sqft) VALUES (1, 55.0);
INSERT INTO cost_per_sqft (building_id, cost_per_sqft) VALUES (2, 65.0);
INSERT INTO cost_per_sqft (building_id, cost_per_sqft) VALUES (3, 45.0);

-- Realistic data for required_space
INSERT INTO required_space (company_id, required_space) VALUES (1, 1200);
INSERT INTO required_space (company_id, required_space) VALUES (2, 1800);
INSERT INTO required_space (company_id, required_space) VALUES (3, 900);

-- Realistic data for available_space
INSERT INTO available_space (building_id, available_space) VALUES (1, 6000);
INSERT INTO available_space (building_id, available_space) VALUES (2, 7000);
INSERT INTO available_space (building_id, available_space) VALUES (3, 5000);

-- Realistic data for space_allocated
INSERT INTO space_allocated (building_id, company_id, space_allocated) VALUES (1, 1, 600.0);
INSERT INTO space_allocated (building_id, company_id, space_allocated) VALUES (1, 2, 800.0);
INSERT INTO space_allocated (building_id, company_id, space_allocated) VALUES (2, 3, 900.0);
```