# Complete GUROBIPY implementation - Retry Attempt 4

import gurobipy as gp
from gurobipy import GRB

def optimize_investment():
    # 1. MODEL & DATA SETUP
    model = gp.Model("culture_company_investment")
    
    # 2. VARIABLES
    x_b = model.addVar(vtype=GRB.CONTINUOUS, name="x_book_club", lb=100000, ub=500000)
    x_m = model.addVar(vtype=GRB.CONTINUOUS, name="x_movie", lb=150000, ub=600000)
    
    # 3. OBJECTIVE FUNCTION
    model.setObjective(0.15 * x_b + 0.20 * x_m, GRB.MAXIMIZE)
    
    # 4. CONSTRAINTS
    # Budget Constraint
    model.addConstr(x_b + x_m <= 1000000, name="budget_constraint")
    
    # Minimum Total Profit Constraint
    model.addConstr(0.15 * x_b + 0.20 * x_m >= 200000, name="min_profit_constraint")
    
    # 5. SOLVING & RESULTS
    model.optimize()
    
    if model.status == GRB.OPTIMAL:
        print(f"Optimal value: {model.objVal}")
        print(f"Investment in Book Clubs: {x_b.x}")
        print(f"Investment in Movies: {x_m.x}")
    elif model.status == GRB.INFEASIBLE:
        print("Problem is infeasible")
        # Analyze the infeasibility
        model.computeIIS()
        model.write("model.ilp")
        print("IIS written to file 'model.ilp'")
    elif model.status == GRB.UNBOUNDED:
        print("Problem is unbounded")
    
    return model

# Execute the optimization
optimize_investment()