# Complete Optimization Problem and Solution: debate

## 1. Problem Context and Goals

### Context  
A debate organization is focused on maximizing audience engagement by strategically assigning participants to debates. Participants come from various districts and political parties, and the organization aims to ensure diversity and fairness in representation. The key operational decision involves assigning participants to specific debates and sides (Affirmative or Negative) while adhering to constraints such as limiting the number of debates each participant can join and ensuring a balance between sides in each debate.  

The organization uses the number of audience members for each debate as a weighting factor to prioritize debates with higher engagement. Additionally, participant age is considered to limit the number of debates they can participate in, ensuring fairness and preventing overcommitment. The business configuration includes scalar parameters such as the typical audience size for debates and a limit on the number of debates a participant can join. These parameters are critical for weighting the objective function and enforcing constraints.  

### Goals  
The primary goal is to maximize total audience engagement across all debates. This is achieved by assigning participants to debates in a way that prioritizes debates with larger audiences. Success is measured by the weighted sum of audience sizes for the debates to which participants are assigned. The optimization process ensures that the assignments respect constraints on participant availability, side balance, and age-based limitations.  

## 2. Constraints  

The optimization problem must adhere to the following constraints:  
1. **Participant Limit**: Each participant can be assigned to no more than one debate. This ensures fairness and prevents overcommitment.  
2. **Side Balance**: For each debate, the number of participants assigned to the Affirmative side must equal the number assigned to the Negative side. This ensures fairness and balance in the debate structure.  
3. **Minimum Participation**: Each debate must have at least one participant assigned to it. This ensures that all debates are conducted.  
4. **Age-Based Constraint**: The number of debates a participant can join is limited by their age, specifically by dividing their age by 25. This ensures that younger participants are not overburdened.  

These constraints are designed to maintain fairness, balance, and operational feasibility while aligning with the linear structure of the optimization problem.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Schema changes include creating a new table for audience size, updating business configuration logic to include missing scalar parameters, and ensuring all optimization requirements are mapped correctly.

CREATE TABLE participant_assignment (
  Debate_ID INTEGER,
  People_ID INTEGER,
  Side STRING
);

CREATE TABLE people (
  People_ID INTEGER,
  District STRING,
  Party STRING,
  Age INTEGER
);

CREATE TABLE audience_size (
  Debate_ID INTEGER,
  Num_of_Audience INTEGER
);
```

### Data Dictionary  
- **participant_assignment**: Represents the assignment of participants to debates on specific sides.  
  - *Debate_ID*: Identifier for the debate.  
  - *People_ID*: Identifier for the participant.  
  - *Side*: The side (Affirmative/Negative) the participant is assigned to.  
- **people**: Represents the participants in the debates.  
  - *People_ID*: Identifier for the participant.  
  - *District*: The district the participant represents.  
  - *Party*: The party the participant represents.  
  - *Age*: The age of the participant.  
- **audience_size**: Represents the number of audience members for each debate.  
  - *Debate_ID*: Identifier for the debate.  
  - *Num_of_Audience*: Number of audience members for the debate.  

### Current Stored Values  
```sql
-- Iteration 2 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic scenarios for a debate organization, considering audience sizes, participant demographics, and debate constraints.

-- Realistic data for participant_assignment
INSERT INTO participant_assignment (Debate_ID, People_ID, Side) VALUES (1, 101, 'Affirmative');
INSERT INTO participant_assignment (Debate_ID, People_ID, Side) VALUES (1, 102, 'Negative');
INSERT INTO participant_assignment (Debate_ID, People_ID, Side) VALUES (2, 103, 'Affirmative');

-- Realistic data for people
INSERT INTO people (People_ID, District, Party, Age) VALUES (101, 'District A', 'Party X', 25);
INSERT INTO people (People_ID, District, Party, Age) VALUES (102, 'District B', 'Party Y', 30);
INSERT INTO people (People_ID, District, Party, Age) VALUES (103, 'District C', 'Party Z', 35);

-- Realistic data for audience_size
INSERT INTO audience_size (Debate_ID, Num_of_Audience) VALUES (1, 150);
INSERT INTO audience_size (Debate_ID, Num_of_Audience) VALUES (2, 200);
INSERT INTO audience_size (Debate_ID, Num_of_Audience) VALUES (3, 100);
```