# Complete Optimization Problem and Solution: device

## 1. Problem Context and Goals

### Context  
A retail chain is focused on optimizing the distribution of devices across its shops to minimize shipping costs while ensuring each shop meets its demand and does not exceed its storage capacity. The key decision involves determining the number of each device type to be shipped from a central warehouse to each shop. This decision must account for the shipping cost associated with each device and shop combination, the demand for each device at each shop, and the maximum storage capacity of each shop.  

The shipping cost for each device to each shop is a fixed value, and the total shipping cost is calculated by multiplying the shipping cost by the number of devices shipped. The business configuration includes a maximum storage capacity for each shop, which ensures that the total number of devices shipped to a shop does not exceed its storage limit. This setup naturally leads to a linear optimization formulation, as all relationships are proportional and additive, without any nonlinear interactions such as variable products or divisions.  

### Goals  
The primary goal of this optimization problem is to minimize the total shipping cost incurred by the retail chain. This is achieved by determining the optimal number of devices to ship to each shop, ensuring that the sum of shipping costs across all device and shop combinations is as low as possible. Success is measured by the ability to meet all shop demands while respecting storage capacity limits and ensuring that all shipments are non-negative. The optimization aligns with the business objective of cost efficiency in device distribution.  

## 2. Constraints  

The optimization problem is subject to the following constraints:  
1. **Demand Fulfillment**: The total number of devices shipped to each shop must meet or exceed the demand for each device at that shop. This ensures that all shops have sufficient inventory to meet customer needs.  
2. **Storage Capacity**: The total number of devices shipped to each shop must not exceed the shop’s maximum storage capacity. This ensures that shops are not overstocked, which could lead to operational inefficiencies.  
3. **Non-Negative Shipments**: The number of devices shipped to each shop must be a non-negative integer. This ensures that the solution is practical and feasible in a real-world business context.  

These constraints are expressed in linear terms, ensuring that the optimization problem remains straightforward and computationally tractable.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating tables for shipping costs, demand, and storage capacity. Business configuration logic updated with scalar parameters and formulas.

CREATE TABLE shipping_cost (
  device_id INTEGER,
  shop_id INTEGER,
  cost FLOAT
);

CREATE TABLE demand (
  device_id INTEGER,
  shop_id INTEGER,
  quantity INTEGER
);

CREATE TABLE storage_capacity (
  shop_id INTEGER,
  capacity INTEGER
);

CREATE TABLE stock (
  device_id INTEGER,
  shop_id INTEGER,
  quantity INTEGER
);
```

### Data Dictionary  
- **Shipping Cost**:  
  - **Purpose**: Represents the cost to ship a specific device to a specific shop.  
  - **Optimization Role**: Used as coefficients in the objective function to calculate total shipping costs.  
  - **Columns**:  
    - `device_id`: Identifier for the device.  
    - `shop_id`: Identifier for the shop.  
    - `cost`: Shipping cost for the device to the shop.  

- **Demand**:  
  - **Purpose**: Represents the demand for a specific device at a specific shop.  
  - **Optimization Role**: Used as bounds in the demand fulfillment constraint.  
  - **Columns**:  
    - `device_id`: Identifier for the device.  
    - `shop_id`: Identifier for the shop.  
    - `quantity`: Demand quantity for the device at the shop.  

- **Storage Capacity**:  
  - **Purpose**: Represents the maximum number of devices a shop can store.  
  - **Optimization Role**: Used as bounds in the storage capacity constraint.  
  - **Columns**:  
    - `shop_id`: Identifier for the shop.  
    - `capacity`: Maximum storage capacity for the shop.  

- **Stock**:  
  - **Purpose**: Represents the number of devices to be shipped to a specific shop.  
  - **Optimization Role**: Used as decision variables in the optimization model.  
  - **Columns**:  
    - `device_id`: Identifier for the device.  
    - `shop_id`: Identifier for the shop.  
    - `quantity`: Number of devices to be shipped.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical retail chain operations, considering device demand, shop storage capacities, and shipping costs. Data was generated to ensure a balanced distribution of devices across shops while respecting constraints.

-- Realistic data for shipping_cost
INSERT INTO shipping_cost (device_id, shop_id, cost) VALUES (1, 101, 12.5);
INSERT INTO shipping_cost (device_id, shop_id, cost) VALUES (2, 102, 18.0);
INSERT INTO shipping_cost (device_id, shop_id, cost) VALUES (3, 103, 15.0);

-- Realistic data for demand
INSERT INTO demand (device_id, shop_id, quantity) VALUES (1, 101, 60);
INSERT INTO demand (device_id, shop_id, quantity) VALUES (2, 102, 80);
INSERT INTO demand (device_id, shop_id, quantity) VALUES (3, 103, 70);

-- Realistic data for storage_capacity
INSERT INTO storage_capacity (shop_id, capacity) VALUES (101, 250);
INSERT INTO storage_capacity (shop_id, capacity) VALUES (102, 300);
INSERT INTO storage_capacity (shop_id, capacity) VALUES (103, 200);

-- Realistic data for stock
INSERT INTO stock (device_id, shop_id, quantity) VALUES (1, 101, 20);
INSERT INTO stock (device_id, shop_id, quantity) VALUES (2, 102, 30);
INSERT INTO stock (device_id, shop_id, quantity) VALUES (3, 103, 25);
```