# Complete Optimization Problem and Solution: election_representative

## 1. Problem Context and Goals

### Context  
A political party is focused on maximizing the total number of seats won across multiple elections by strategically allocating campaign resources to its representatives in different states. The party must make decisions on how much campaign resources to allocate to each representative, ensuring that these allocations adhere to a total budget limit, provide a minimum level of support to each representative, and respect state-specific resource caps. The total budget available for campaign resources is set at one million units, ensuring that the party can cover all necessary allocations without exceeding its financial capacity. Each representative must receive at least one thousand units of resources to ensure a baseline level of campaign support. Additionally, the total resources allocated to representatives within any single state cannot exceed fifty thousand units, ensuring a fair distribution of resources across states. These operational parameters are designed to support a linear optimization approach, where the relationships between resource allocations and outcomes are straightforward and proportional.

### Goals  
The primary goal of this optimization problem is to maximize the total number of seats won by the party across all elections. This is achieved by strategically allocating campaign resources to representatives in a way that directly increases the likelihood of winning seats. The success of this strategy is measured by the total seats won, which is calculated as the sum of the seats won by each representative multiplied by the amount of resources allocated to them. The optimization process ensures that the party’s resource allocation decisions are aligned with its objective of maximizing electoral success while adhering to all operational constraints.

## 2. Constraints    

The optimization problem is subject to three key constraints, each designed to ensure that resource allocations are both effective and feasible. First, the total amount of resources allocated to all representatives combined must not exceed the total budget of one million units. This ensures that the party does not overspend its available financial resources. Second, each representative must receive at least one thousand units of resources, guaranteeing that every candidate receives a minimum level of campaign support. Third, the total resources allocated to representatives within any single state must not exceed fifty thousand units, ensuring that no state receives an disproportionate share of resources. These constraints are designed to be linear and proportional, supporting a straightforward optimization approach.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating tables for decision variables and constraint bounds, moving scalar parameters to business configuration logic, and updating the data dictionary to reflect optimization mappings.

CREATE TABLE election (
  Seats INTEGER
);

CREATE TABLE resource_allocation (
  Resource_Amount FLOAT
);

CREATE TABLE state_resource_limits (
  Maximum_Resource_Allocation INTEGER
);
```

### Data Dictionary  
The database schema includes three key tables, each with a specific role in the optimization process. The `election` table stores the number of seats won by each representative, which serves as the coefficient in the objective function. The `resource_allocation` table tracks the amount of campaign resources allocated to each representative, representing the decision variables in the optimization model. The `state_resource_limits` table contains the maximum amount of resources that can be allocated to representatives within each state, serving as a constraint bound in the optimization model. Together, these tables provide the necessary data to support the linear optimization of campaign resource allocations.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic campaign budgets, resource allocation limits, and election outcomes, ensuring they align with the business context and optimization requirements.

-- Realistic data for election
INSERT INTO election (Seats) VALUES (1);
INSERT INTO election (Seats) VALUES (2);
INSERT INTO election (Seats) VALUES (3);

-- Realistic data for resource_allocation
INSERT INTO resource_allocation (Resource_Amount) VALUES (1000.0);
INSERT INTO resource_allocation (Resource_Amount) VALUES (2000.0);
INSERT INTO resource_allocation (Resource_Amount) VALUES (3000.0);

-- Realistic data for state_resource_limits
INSERT INTO state_resource_limits (Maximum_Resource_Allocation) VALUES (50000);
INSERT INTO state_resource_limits (Maximum_Resource_Allocation) VALUES (60000);
INSERT INTO state_resource_limits (Maximum_Resource_Allocation) VALUES (70000);
```