# Complete Optimization Problem and Solution: entrepreneur

## 1. Problem Context and Goals

### Context  
An investor is tasked with allocating a fixed budget across multiple entrepreneurs to maximize the total expected return on investment. The investor must decide how much money to allocate to each entrepreneur, ensuring that the total investment does not exceed the available budget and that no single entrepreneur receives more than a specified maximum amount. The available budget for investment is set at one million dollars, and the maximum amount that can be allocated to any single entrepreneur is two hundred thousand dollars. These parameters are designed to ensure risk management and diversification across the investment portfolio. The expected return rate for each entrepreneur is a key factor in determining the optimal allocation, as it directly influences the total return on investment.

### Goals  
The primary goal of this optimization problem is to maximize the total expected return on investment by strategically allocating the available budget across the entrepreneurs. Success is measured by the total return generated from the investments, which is calculated by multiplying the amount allocated to each entrepreneur by their respective expected return rate and summing these values across all entrepreneurs. The optimization process ensures that the allocation decisions are made in a way that respects the budget and individual investment limits while maximizing the overall return.

## 2. Constraints    

The optimization problem is subject to two key constraints:  
1. **Total Budget Constraint**: The sum of all investments allocated to the entrepreneurs must not exceed the total available budget of one million dollars. This ensures that the investor does not overspend and stays within the financial limits.  
2. **Individual Investment Limit**: The amount allocated to any single entrepreneur must not exceed two hundred thousand dollars. This constraint ensures that the investment portfolio remains diversified and that no single entrepreneur receives an disproportionately large share of the budget.  

These constraints are designed to align with the investor's risk management strategy and ensure that the allocation decisions are both financially sound and operationally feasible.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes and configuration logic updates implemented to address missing optimization requirements and mapping gaps identified by the OR expert.

CREATE TABLE entrepreneurs (
  entrepreneur_id INTEGER,
  return_rate FLOAT,
  investment FLOAT
);
```

### Data Dictionary  
The `entrepreneurs` table contains the following columns, each with a specific business purpose and optimization role:  
- **entrepreneur_id**: A unique identifier for each entrepreneur, used to index the decision variables and constraints in the optimization problem.  
- **return_rate**: The expected return rate for each entrepreneur, which serves as the coefficient in the objective function to maximize the total return on investment.  
- **investment**: The amount of money allocated to each entrepreneur, which is the decision variable in the optimization problem.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic investment scenarios, considering typical return rates and budget constraints for small to medium-sized ventures.

-- Realistic data for entrepreneurs
INSERT INTO entrepreneurs (entrepreneur_id, return_rate, investment) VALUES (1, 0.12, 150000);
INSERT INTO entrepreneurs (entrepreneur_id, return_rate, investment) VALUES (2, 0.18, 200000);
INSERT INTO entrepreneurs (entrepreneur_id, return_rate, investment) VALUES (3, 0.1, 100000);
```