# Complete Optimization Problem and Solution: farm

## 1. Problem Context and Goals

### Context  
A farm competition organizer is tasked with selecting the best farms to participate in an event hosted by a city. The goal is to maximize the overall quality of the competition by inviting farms that contribute the most to the event's success. The quality of each farm is determined by a weighted sum of the animals it possesses, including horses, cattle, pigs, sheep, and goats. The weights assigned to each animal type reflect their relative importance in the competition.  

The organizer must decide which farms to invite, ensuring that the total number of invited farms does not exceed the city's capacity to host them. Additionally, the city has specific limits on the total number of each type of animal that can be accommodated during the event. These limits include the maximum number of horses, cattle, pigs, and sheep and goats.  

The decision to invite a farm is represented by a binary choice: a farm is either invited (1) or not invited (0). The quality score of each farm is calculated as a weighted sum of its animals, with weights assigned as follows: horses (30%), cattle (25%), pigs (20%), and sheep and goats (25%).  

The city's capacity constraints are defined by the following parameters:  
- The maximum number of farms that can be hosted is 10.  
- The maximum number of horses that can be accommodated is 50.  
- The maximum number of cattle that can be accommodated is 100.  
- The maximum number of pigs that can be accommodated is 200.  
- The maximum number of sheep and goats that can be accommodated is 150.  

These constraints ensure that the event remains manageable and aligns with the city's hosting capabilities.  

### Goals  
The primary goal of the optimization problem is to maximize the total quality score of the invited farms. This is achieved by selecting a combination of farms whose collective quality score is the highest possible, while respecting the city's capacity constraints.  

Success is measured by the total quality score of the invited farms, which is calculated as the sum of the quality scores of each invited farm. The quality score of each farm is derived from the weighted sum of its animals, ensuring that farms with a higher number of animals, particularly those with higher weights, contribute more to the overall score.  

## 2. Constraints  

The optimization problem must adhere to the following constraints:  
1. The total number of invited farms cannot exceed the city's maximum hosting capacity of 10 farms.  
2. The total number of horses from all invited farms cannot exceed the city's maximum capacity of 50 horses.  
3. The total number of cattle from all invited farms cannot exceed the city's maximum capacity of 100 cattle.  
4. The total number of pigs from all invited farms cannot exceed the city's maximum capacity of 200 pigs.  
5. The total number of sheep and goats from all invited farms cannot exceed the city's maximum capacity of 150 sheep and goats.  

These constraints ensure that the event remains within the city's logistical and operational limits, while still allowing for the selection of high-quality farms.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating tables for farms, animals, and city capacities, and updating business configuration logic to handle scalar parameters and formulas for optimization.

CREATE TABLE farms (
  farm_id INTEGER,
  invite_status BOOLEAN
);

CREATE TABLE animals (
  farm_id INTEGER,
  horses INTEGER,
  cattle INTEGER,
  pigs INTEGER,
  sheep_and_goats INTEGER
);

CREATE TABLE city_capacities (
  max_farms INTEGER,
  max_horses INTEGER,
  max_cattle INTEGER,
  max_pigs INTEGER,
  max_sheep_goats INTEGER
);
```

### Data Dictionary  
- **farms**: Represents farms eligible for the competition.  
  - **farm_id**: Unique identifier for each farm.  
  - **invite_status**: Indicates whether the farm is invited to the competition (True/False).  

- **animals**: Represents the number of each type of animal on each farm.  
  - **farm_id**: Links to the farms table to identify which farm the animals belong to.  
  - **horses**: Number of horses on the farm.  
  - **cattle**: Number of cattle on the farm.  
  - **pigs**: Number of pigs on the farm.  
  - **sheep_and_goats**: Number of sheep and goats on the farm.  

- **city_capacities**: Represents the city's capacity constraints for hosting the competition.  
  - **max_farms**: Maximum number of farms the city can host.  
  - **max_horses**: Maximum number of horses the city can accommodate.  
  - **max_cattle**: Maximum number of cattle the city can accommodate.  
  - **max_pigs**: Maximum number of pigs the city can accommodate.  
  - **max_sheep_goats**: Maximum number of sheep and goats the city can accommodate.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical farm sizes and city hosting capacities, ensuring a balance between farm quality and city constraints.

-- Realistic data for farms
INSERT INTO farms (farm_id, invite_status) VALUES (1, False);
INSERT INTO farms (farm_id, invite_status) VALUES (2, False);
INSERT INTO farms (farm_id, invite_status) VALUES (3, False);

-- Realistic data for animals
INSERT INTO animals (farm_id, horses, cattle, pigs, sheep_and_goats) VALUES (1, 5, 20, 50, 30);
INSERT INTO animals (farm_id, horses, cattle, pigs, sheep_and_goats) VALUES (2, 10, 30, 60, 40);
INSERT INTO animals (farm_id, horses, cattle, pigs, sheep_and_goats) VALUES (3, 15, 40, 70, 50);

-- Realistic data for city_capacities
INSERT INTO city_capacities (max_farms, max_horses, max_cattle, max_pigs, max_sheep_goats) VALUES (10, 50, 100, 200, 150);
```