-- Iteration 2 Database Schema
-- Objective: Schema changes include creating a table for flight assignments to address the missing decision variable. Configuration logic updates include scalar parameters for velocity and altitude constraints and formulas for fuel consumption calculations.

CREATE TABLE fuel_consumption_coefficients (
  flight_id INTEGER,
  coefficient FLOAT
);

CREATE TABLE velocity_constraints (
  flight_id INTEGER,
  velocity_min INTEGER,
  velocity_max INTEGER
);

CREATE TABLE altitude_constraints (
  flight_id INTEGER,
  altitude_min INTEGER,
  altitude_max INTEGER
);

CREATE TABLE airport_capacities (
  airport_id INTEGER,
  capacity INTEGER
);

CREATE TABLE company_capacities (
  company_id INTEGER,
  capacity INTEGER
);

CREATE TABLE flight_assignments (
  flight_id INTEGER,
  airport_id INTEGER,
  company_id INTEGER,
  assignment BOOLEAN
);

