# Complete Optimization Problem and Solution: icfp_1

## 1. Problem Context and Goals

### Context  
A research institution is focused on optimizing the allocation of its researchers across various projects to maximize the overall research output. The output is measured by the number of papers published, with a particular emphasis on the order of authorship to reflect the varying contributions of researchers. The institution must ensure that the allocation respects operational constraints, such as the maximum number of researchers that can be assigned to a single institution and the maximum number of papers a researcher can be involved in.  

The decision at hand is whether to assign a specific researcher to a particular institution for a given paper. This decision is represented by a binary indicator, where a value of 1 signifies an assignment and 0 signifies no assignment. The institution aims to maximize the total weighted research output, where the weight is determined by the order of authorship. For example, first authors are given a higher weight than subsequent authors, reflecting their greater contribution to the paper.  

The business configuration includes a weight for the order of authorship, which is used to prioritize papers based on the researcher's role. Additionally, there are constraints on the maximum number of researchers per institution and the maximum number of papers per researcher. These constraints ensure that the allocation remains feasible and aligns with the institution's operational capacity.  

### Goals  
The primary goal of this optimization problem is to maximize the total weighted research output. This is achieved by assigning researchers to institutions and papers in a way that respects the operational constraints. The weight for each paper is determined by the order of authorship, with higher weights assigned to papers where the researcher is a primary contributor. Success is measured by the total sum of these weighted assignments, ensuring that the institution's research output is optimized while adhering to the defined constraints.  

## 2. Constraints  

The optimization problem must adhere to the following constraints:  
1. **Maximum Researchers per Institution**: The total number of researchers assigned to any single institution cannot exceed the predefined maximum limit. This ensures that institutions are not overburdened with too many researchers.  
2. **Maximum Papers per Researcher**: The total number of papers assigned to any single researcher cannot exceed the predefined maximum limit. This ensures that researchers are not overcommitted and can maintain a balanced workload.  
3. **Single Assignment per Paper**: Each paper must be assigned to exactly one researcher-institution pair. This ensures that every paper is accounted for and that there are no overlaps or gaps in the allocation.  

These constraints are designed to ensure that the allocation of researchers to institutions and papers is both feasible and aligned with the institution's operational capacity.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema adjustments include creating new tables for missing optimization data, modifying existing tables to better align with OR expert's mapping, and moving scalar parameters and formulas to business_configuration_logic.json.

CREATE TABLE Authorship (
  authID INTEGER,
  instID INTEGER,
  paperID INTEGER,
  authOrder INTEGER
);
```

### Data Dictionary  
The **Authorship** table represents the assignment of researchers to institutions and papers. It plays a critical role in the optimization problem by providing the necessary data to make allocation decisions.  

- **authID**: Represents the unique identifier for each researcher. This is used to track which researcher is being assigned to a paper and institution.  
- **instID**: Represents the unique identifier for each institution. This is used to track which institution the researcher is being assigned to.  
- **paperID**: Represents the unique identifier for each paper. This is used to track which paper the researcher is being assigned to.  
- **authOrder**: Represents the order of authorship for the researcher on the paper. This is used to determine the weight of the paper in the objective function, with higher values indicating a greater contribution.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical research institution operations, ensuring realistic constraints and weights that align with the optimization objective of maximizing research output.

-- Realistic data for Authorship
INSERT INTO Authorship (authID, instID, paperID, authOrder) VALUES (1, 101, 201, 1);
INSERT INTO Authorship (authID, instID, paperID, authOrder) VALUES (2, 102, 202, 2);
INSERT INTO Authorship (authID, instID, paperID, authOrder) VALUES (3, 103, 203, 3);
```