# Complete Optimization Problem and Solution: insurance_policies

## 1. Problem Context and Goals

### Context  
The insurance company is focused on minimizing the total cost of settling claims while ensuring fairness and adherence to budget constraints. The company must allocate settlement amounts across multiple claims in a way that reduces the overall payout. This allocation is subject to several operational constraints:  
- The total amount settled across all claims must not exceed the total budget available for settlements.  
- The amount settled for each individual claim must not exceed the maximum settlement amount allowed per claim.  
- The amount settled for each claim must be at least a minimum percentage of the claimed amount, ensuring fairness to policyholders.  

The total budget available for settlements is currently set at $500,000, and the maximum amount that can be settled per claim is $50,000. Additionally, the company ensures that each settlement is at least 50% of the claimed amount. These parameters are critical for maintaining financial stability and fairness in the settlement process.  

### Goals  
The primary goal of this optimization problem is to minimize the total amount settled across all claims. This is achieved by determining the optimal settlement amount for each claim while adhering to the constraints mentioned above. Success is measured by achieving the lowest possible total settlement cost without violating any of the operational or fairness constraints.  

## 2. Constraints  

The optimization problem is subject to the following constraints, which ensure that the settlement process remains within operational and financial limits:  
1. **Total Budget Constraint**: The sum of all settlement amounts across claims must not exceed the total budget available for settlements, which is $500,000.  
2. **Maximum Settlement per Claim**: The settlement amount for any individual claim must not exceed the maximum allowed settlement per claim, which is $50,000.  
3. **Minimum Settlement Percentage**: The settlement amount for each claim must be at least 50% of the claimed amount, ensuring a fair minimum payout to policyholders.  

These constraints are designed to align with the company’s financial and operational policies while maintaining fairness in the settlement process.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include adding a Budgets table for Total_Budget and Maximum_Settlement_Per_Claim. Configuration logic updated with scalar parameters for Total_Budget and Maximum_Settlement_Per_Claim, and a business logic formula for minimum settlement percentage.

CREATE TABLE Claims (
  Claim_ID INTEGER,
  Amount_Claimed FLOAT
);

CREATE TABLE Settlements (
  Claim_ID INTEGER,
  Amount_Settled FLOAT
);

CREATE TABLE Budgets (
  Total_Budget FLOAT,
  Maximum_Settlement_Per_Claim FLOAT
);
```

### Data Dictionary  
- **Claims Table**:  
  - **Claim_ID**: A unique identifier for each insurance claim.  
  - **Amount_Claimed**: The amount requested by the policyholder for each claim. This value is used to determine the minimum settlement amount per claim.  

- **Settlements Table**:  
  - **Claim_ID**: A unique identifier for each claim, linking it to the corresponding settlement.  
  - **Amount_Settled**: The amount allocated to settle each claim. This is the decision variable to be optimized.  

- **Budgets Table**:  
  - **Total_Budget**: The total amount of money available for settling all claims. This value is used as an upper bound for the sum of all settlements.  
  - **Maximum_Settlement_Per_Claim**: The maximum amount that can be allocated to settle any single claim. This value is used as an upper bound for individual settlements.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic insurance claim scenarios, ensuring that the total budget and maximum settlement per claim are sufficient to cover the claims while maintaining business profitability. The minimum settlement percentage ensures fairness to policyholders.

-- Realistic data for Claims
INSERT INTO Claims (Claim_ID, Amount_Claimed) VALUES (1, 15000);
INSERT INTO Claims (Claim_ID, Amount_Claimed) VALUES (2, 25000);
INSERT INTO Claims (Claim_ID, Amount_Claimed) VALUES (3, 35000);

-- Realistic data for Settlements
INSERT INTO Settlements (Claim_ID, Amount_Settled) VALUES (1, 7500);
INSERT INTO Settlements (Claim_ID, Amount_Settled) VALUES (2, 12500);
INSERT INTO Settlements (Claim_ID, Amount_Settled) VALUES (3, 17500);

-- Realistic data for Budgets
INSERT INTO Budgets (Total_Budget, Maximum_Settlement_Per_Claim) VALUES (500000, 50000);
```