# Complete DOCPLEX implementation - Retry Attempt 1

from docplex.mp.model import Model

def movie_recommendation_optimization():
    # 1. MODEL & DATA SETUP
    mdl = Model(name="movie_recommendation_optimization")
    
    # Data from the database
    movie_ids = [1, 2, 3]
    reviewer_ids = [1, 2, 3]
    
    # Star ratings
    star_ratings = {
        (1, 1): 5,
        (2, 2): 4,
        (3, 3): 3
    }
    
    # Movie recommendation limits
    movie_limits = {
        1: 10,
        2: 7,
        3: 5
    }
    
    # Reviewer recommendation limits
    reviewer_limits = {
        1: 5,
        2: 4,
        3: 3
    }
    
    # 2. VARIABLES
    x = {(i, j): mdl.integer_var(name=f"x_{i}_{j}", lb=0) for i in reviewer_ids for j in movie_ids}
    
    # 3. OBJECTIVE FUNCTION
    objective = mdl.sum(star_ratings.get((i, j), 0) * x[i, j] for i in reviewer_ids for j in movie_ids)
    mdl.maximize(objective)
    
    # 4. CONSTRAINTS
    
    # Movie Recommendation Limits
    for j in movie_ids:
        mdl.add_constraint(mdl.sum(x[i, j] for i in reviewer_ids) <= movie_limits[j], ctname=f"movie_limit_{j}")
    
    # Reviewer Recommendation Limits
    for i in reviewer_ids:
        mdl.add_constraint(mdl.sum(x[i, j] for j in movie_ids) <= reviewer_limits[i], ctname=f"reviewer_limit_{i}")
    
    # 5. SOLVING & RESULTS
    solution = mdl.solve()
    
    if solution:
        print(f"Optimal value: {solution.objective_value}")
        for i in reviewer_ids:
            for j in movie_ids:
                value = solution.get_value(x[i, j])
                if value > 0:
                    print(f"x[{i},{j}] = {value}")
    else:
        print("No solution found")
        print(f"Status: {mdl.solve_details.status}")
    
    return mdl

# Execute the optimization
movie_recommendation_optimization()