# Complete Optimization Problem and Solution: performance_attendance

## 1. Problem Context and Goals

### Context  
A music ensemble is focused on optimizing the number of pieces each member performs across various performances to maximize overall attendance. The ensemble must make decisions about how many pieces each member should perform in each performance, ensuring that these decisions align with the goal of attracting the largest possible audience. The attendance for each performance is a key factor in this optimization, as it directly influences the overall success of the ensemble's performances.  

The ensemble operates under specific constraints: each member has a maximum number of pieces they can perform, and each performance has a maximum number of pieces that can be included. Additionally, every member must perform at least one piece to ensure fair participation. The attendance for each performance is a known value and is used to weight the importance of each performance in the optimization process.  

The business configuration includes a scalar parameter for attendance, which represents the average attendance across performances. This parameter simplifies the objective function by providing a consistent measure of attendance impact.  

### Goals  
The primary goal of this optimization is to maximize the total attendance across all performances by strategically assigning the number of pieces each member performs. Success is measured by the overall attendance achieved, which is directly influenced by the number of pieces performed by each member in each performance. The optimization ensures that the ensemble's performances are as attractive as possible to the audience while respecting the operational constraints of the members and performances.  

## 2. Constraints  

The optimization must adhere to the following constraints:  
1. **Maximum Pieces per Member**: Each member cannot perform more than a specified maximum number of pieces across all performances. This ensures that no member is overburdened.  
2. **Maximum Pieces per Performance**: Each performance cannot include more than a specified maximum number of pieces. This ensures that performances remain manageable and focused.  
3. **Minimum Pieces per Member**: Each member must perform at least one piece across all performances. This ensures fair participation and engagement from all members.  

These constraints are designed to maintain operational feasibility while achieving the optimization goal.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Added attendance_data table to capture attendance per performance, updated business configuration logic with attendance-related scalar parameters, and ensured all mappings align with OR expert requirements.

CREATE TABLE member_constraints (
  member_id INTEGER,
  max_pieces INTEGER
);

CREATE TABLE performance_constraints (
  performance_id INTEGER,
  max_pieces INTEGER
);

CREATE TABLE member_attendance (
  member_id INTEGER,
  performance_id INTEGER,
  num_of_pieces INTEGER
);

CREATE TABLE attendance_data (
  performance_id INTEGER,
  attendance INTEGER
);
```

### Data Dictionary  
- **member_constraints**:  
  - **member_id**: Unique identifier for each member.  
  - **max_pieces**: Maximum number of pieces the member can perform across all performances.  

- **performance_constraints**:  
  - **performance_id**: Unique identifier for each performance.  
  - **max_pieces**: Maximum number of pieces allowed in the performance.  

- **member_attendance**:  
  - **member_id**: Unique identifier for each member.  
  - **performance_id**: Unique identifier for each performance.  
  - **num_of_pieces**: Number of pieces the member performs in the performance.  

- **attendance_data**:  
  - **performance_id**: Unique identifier for each performance.  
  - **attendance**: Attendance for the performance, used to weight the importance of the performance in the optimization.  

### Current Stored Values  
```sql
-- Iteration 2 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic scenarios for a music ensemble, considering typical attendance numbers, member capabilities, and performance constraints. The data ensures a balanced distribution of pieces among members and performances, while respecting the optimization constraints.

-- Realistic data for member_constraints
INSERT INTO member_constraints (member_id, max_pieces) VALUES (1, 5);
INSERT INTO member_constraints (member_id, max_pieces) VALUES (2, 4);
INSERT INTO member_constraints (member_id, max_pieces) VALUES (3, 3);

-- Realistic data for performance_constraints
INSERT INTO performance_constraints (performance_id, max_pieces) VALUES (1, 10);
INSERT INTO performance_constraints (performance_id, max_pieces) VALUES (2, 8);
INSERT INTO performance_constraints (performance_id, max_pieces) VALUES (3, 6);

-- Realistic data for member_attendance
INSERT INTO member_attendance (member_id, performance_id, num_of_pieces) VALUES (1, 1, 3);
INSERT INTO member_attendance (member_id, performance_id, num_of_pieces) VALUES (2, 1, 2);
INSERT INTO member_attendance (member_id, performance_id, num_of_pieces) VALUES (3, 1, 1);

-- Realistic data for attendance_data
INSERT INTO attendance_data (performance_id, attendance) VALUES (1, 200);
INSERT INTO attendance_data (performance_id, attendance) VALUES (2, 150);
INSERT INTO attendance_data (performance_id, attendance) VALUES (3, 100);
```