# Complete Optimization Problem and Solution: pets_1

## 1. Problem Context and Goals

### Context  
The university is tasked with efficiently allocating pet care resources to students based on their pets' needs and the students' demographics. The primary business decision involves determining the amount of resources to allocate to each pet, represented as a continuous variable. The operational parameters are designed to minimize the total cost of pet care, which is calculated by multiplying the cost associated with each pet type by the resources allocated to each pet. 

The business configuration includes two critical scalar parameters: the minimum resource allocation per pet, ensuring that no pet receives negative resources, and the maximum resource allocation per pet, which reflects the university's budget constraints. These parameters serve as lower and upper bounds for the decision variables, respectively. The optimization problem is designed to ensure that each pet receives adequate care based on its type, age, and weight, while the total resources allocated do not exceed the available budget and weight capacity.

### Goals  
The optimization goal is to minimize the total cost of pet care. This is achieved by efficiently allocating resources to each pet, ensuring that the sum of the costs associated with each pet type multiplied by the resources allocated to each pet is as low as possible. Success is measured by achieving the lowest possible total cost while adhering to the constraints on resource allocation and care requirements.

## 2. Constraints    

The optimization problem is subject to several constraints that ensure the allocation of resources is both feasible and adequate. Each pet must receive a minimum level of care based on its type, ensuring that no pet is neglected. Additionally, the resources allocated to each pet must not exceed the maximum care requirement for its type, preventing over-allocation. 

The total resources allocated across all pets must not exceed the university's maximum resource allocation limit, ensuring that the budget is not exceeded. Finally, each pet must receive at least the minimum resource allocation, ensuring that no pet is allocated negative resources. These constraints are designed to maintain a balance between adequate care and budget limitations.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Added resource_allocation table to map decision variables, updated business configuration logic with new scalar parameters, and ensured all mappings align with OR expert's requirements.

CREATE TABLE pet_type_costs (
  pet_type STRING,
  cost FLOAT
);

CREATE TABLE pet_care_requirements (
  pet_type STRING,
  min_care FLOAT,
  max_care FLOAT
);

CREATE TABLE resource_allocation (
  pet_id STRING,
  amount FLOAT
);


```

### Data Dictionary  
- **pet_type_costs**: This table contains the cost associated with caring for each pet type. The `pet_type` column identifies the type of pet, and the `cost` column represents the cost per pet type, which is used as a coefficient in the objective function.
  
- **pet_care_requirements**: This table defines the minimum and maximum care requirements for each pet type. The `pet_type` column identifies the type of pet, while the `min_care` and `max_care` columns represent the lower and upper bounds for resource allocation, respectively.
  
- **resource_allocation**: This table tracks the amount of resources allocated to each pet. The `pet_id` column uniquely identifies each pet, and the `amount` column represents the decision variable in the optimization problem, indicating the resources allocated to each pet.

### Current Stored Values  
```sql
-- Iteration 2 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic pet care costs, care requirements, and resource allocation limits, ensuring that the optimization problem remains meaningful and solvable.

-- Realistic data for pet_type_costs
INSERT INTO pet_type_costs (pet_type, cost) VALUES ('dog', 50.0);
INSERT INTO pet_type_costs (pet_type, cost) VALUES ('cat', 30.0);
INSERT INTO pet_type_costs (pet_type, cost) VALUES ('bird', 20.0);

-- Realistic data for pet_care_requirements
INSERT INTO pet_care_requirements (pet_type, min_care, max_care) VALUES ('dog', 10.0, 100.0);
INSERT INTO pet_care_requirements (pet_type, min_care, max_care) VALUES ('cat', 5.0, 50.0);
INSERT INTO pet_care_requirements (pet_type, min_care, max_care) VALUES ('bird', 3.0, 30.0);

-- Realistic data for resource_allocation
INSERT INTO resource_allocation (pet_id, amount) VALUES ('pet1', 50.0);
INSERT INTO resource_allocation (pet_id, amount) VALUES ('pet2', 30.0);
INSERT INTO resource_allocation (pet_id, amount) VALUES ('pet3', 20.0);


```