# Complete Optimization Problem and Solution: phone_1

## 1. Problem Context and Goals

### Context  
A phone manufacturer is tasked with optimizing the production of phones to minimize total costs while meeting specific hardware and accreditation requirements. The manufacturer must decide how many phones to produce for each combination of chip model and screen mode. Each chip model has an associated cost, RAM capacity, and ROM capacity, while each screen mode has an associated cost and accreditation level. The goal is to determine the optimal number of phones to produce for each chip model and screen mode combination, ensuring that the total RAM, ROM, and accreditation levels across all produced phones meet or exceed the minimum requirements set by the business.  

The business has established the following minimum requirements for all phones produced:  
- **Total RAM Required**: 8,000 MiB  
- **Total ROM Required**: 128,000 MiB  
- **Total Accreditation Level Required**: 5  

These requirements ensure that the phones meet production targets and quality standards. The manufacturer must balance the costs of chip models and screen modes while adhering to these constraints.  

### Goals  
The primary goal of this optimization problem is to minimize the total cost of producing phones. This cost is determined by the sum of the costs of the chip models and screen modes used in each phone, multiplied by the number of phones produced for each combination. Success is measured by achieving the lowest possible total cost while ensuring that the minimum RAM, ROM, and accreditation level requirements are met.  

## 2. Constraints  

The optimization problem must adhere to the following constraints:  
1. **Total RAM Constraint**: The combined RAM capacity of all phones produced must meet or exceed the minimum total RAM requirement of 8,000 MiB. This is calculated by summing the RAM capacity of each chip model multiplied by the number of phones produced with that chip model.  
2. **Total ROM Constraint**: The combined ROM capacity of all phones produced must meet or exceed the minimum total ROM requirement of 128,000 MiB. This is calculated by summing the ROM capacity of each chip model multiplied by the number of phones produced with that chip model.  
3. **Total Accreditation Level Constraint**: The combined accreditation level of all phones produced must meet or exceed the minimum total accreditation level requirement of 5. This is calculated by summing the accreditation level of each screen mode multiplied by the number of phones produced with that screen mode.  

These constraints ensure that the phones produced meet the necessary hardware and quality standards while minimizing production costs.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes and configuration logic updates implemented to address missing optimization data requirements and mapping gaps identified by the OR expert.

CREATE TABLE chip_models (
  chip_model_id INTEGER,
  cost FLOAT,
  RAM_MiB INTEGER,
  ROM_MiB INTEGER
);

CREATE TABLE screen_modes (
  screen_mode_id INTEGER,
  cost FLOAT,
  Accreditation_level INTEGER
);

CREATE TABLE phone_production (
  chip_model_id INTEGER,
  screen_mode_id INTEGER,
  quantity INTEGER
);
```

### Data Dictionary  
- **chip_models**:  
  - **chip_model_id**: Unique identifier for each chip model.  
  - **cost**: The cost associated with using the chip model in phone production.  
  - **RAM_MiB**: The RAM capacity of the chip model, measured in MiB.  
  - **ROM_MiB**: The ROM capacity of the chip model, measured in MiB.  

- **screen_modes**:  
  - **screen_mode_id**: Unique identifier for each screen mode.  
  - **cost**: The cost associated with using the screen mode in phone production.  
  - **Accreditation_level**: The accreditation level of the screen mode, indicating its quality standard.  

- **phone_production**:  
  - **chip_model_id**: The chip model used in the production of a specific phone.  
  - **screen_mode_id**: The screen mode used in the production of a specific phone.  
  - **quantity**: The number of phones produced with the specified chip model and screen mode combination.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on industry standards for phone manufacturing, ensuring realistic costs, capacities, and accreditation levels. The data was designed to create a meaningful optimization problem by balancing costs and constraints.

-- Realistic data for chip_models
INSERT INTO chip_models (chip_model_id, cost, RAM_MiB, ROM_MiB) VALUES (1, 50.0, 2048, 32768);
INSERT INTO chip_models (chip_model_id, cost, RAM_MiB, ROM_MiB) VALUES (2, 75.0, 4096, 65536);
INSERT INTO chip_models (chip_model_id, cost, RAM_MiB, ROM_MiB) VALUES (3, 100.0, 8192, 131072);

-- Realistic data for screen_modes
INSERT INTO screen_modes (screen_mode_id, cost, Accreditation_level) VALUES (1, 30.0, 3);
INSERT INTO screen_modes (screen_mode_id, cost, Accreditation_level) VALUES (2, 45.0, 4);
INSERT INTO screen_modes (screen_mode_id, cost, Accreditation_level) VALUES (3, 60.0, 5);

-- Realistic data for phone_production
INSERT INTO phone_production (chip_model_id, screen_mode_id, quantity) VALUES (1, 1, 10);
INSERT INTO phone_production (chip_model_id, screen_mode_id, quantity) VALUES (2, 2, 20);
INSERT INTO phone_production (chip_model_id, screen_mode_id, quantity) VALUES (3, 3, 30);
```