# Complete Optimization Problem and Solution: poker_player

## 1. Problem Context and Goals

### Context  
A poker tournament organizer is tasked with selecting a subset of poker players to maximize the total earnings of the selected players. The selection process must ensure diversity in nationalities, requiring that the chosen players represent at least three different countries. Additionally, the organizer aims to limit the number of selected players with low money ranks, ensuring that no more than 20% of the selected players have a money rank below 50.  

The decision to select a player is represented by a binary choice: each player is either selected (1) or not selected (0). The total earnings of the selected players are calculated by summing the earnings of each chosen player. The organizer uses the players' earnings as the primary metric to optimize, while the constraints on nationality diversity and money rank are enforced to maintain a balanced and competitive tournament lineup.  

The business logic for nationality diversity is defined by a configuration that ensures the selected players come from at least three distinct nationalities. This logic is applied as a constraint in the optimization process. Similarly, the money rank constraint is derived from the players' current money ranks, ensuring that the selection adheres to the 20% limit for low-ranked players.  

### Goals  
The primary goal of this optimization problem is to maximize the total earnings of the selected poker players. This is achieved by selecting a subset of players whose combined earnings are as high as possible, while adhering to the constraints on nationality diversity and money rank.  

Success is measured by the total earnings of the selected players, which directly corresponds to the sum of the earnings of each chosen player. The optimization process ensures that the selection meets the predefined constraints, resulting in a lineup that is both financially optimal and operationally feasible.  

## 2. Constraints  

1. **Nationality Diversity Constraint**: The selected players must represent at least three different nationalities. This ensures a diverse lineup that reflects the global nature of the tournament.  

2. **Money Rank Constraint**: No more than 20% of the selected players can have a money rank below 50. This ensures that the majority of the selected players are competitively ranked, maintaining the tournament's prestige and competitiveness.  

These constraints are designed to align with the business requirements and are expressed in a way that naturally leads to linear mathematical forms, ensuring the optimization problem remains linear and tractable.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Added Nationality column to poker_player table to enforce diversity constraint. Updated business configuration logic to include nationality diversity formula.

CREATE TABLE poker_player (
  Earnings FLOAT,
  Money_Rank INTEGER,
  Selected BOOLEAN,
  Nationality STRING
);

CREATE TABLE player_selection (
  Player_ID INTEGER,
  Selected BOOLEAN
);
```

### Data Dictionary  
- **poker_player**: Stores information about poker players, including their earnings, money rank, selection status, and nationality.  
  - **Earnings**: The earnings of each poker player, used as coefficients in the objective function to maximize total earnings.  
  - **Money_Rank**: The money rank of each player, used to enforce the constraint limiting the number of low-ranked players.  
  - **Selected**: A binary indicator (true/false) representing whether the player is selected, serving as the decision variable in the optimization model.  
  - **Nationality**: The nationality of each player, used to enforce the diversity constraint requiring at least three distinct nationalities.  

- **player_selection**: Tracks the selection status of each player, linking to the poker_player table.  
  - **Player_ID**: A unique identifier for each player, linking to the poker_player table.  
  - **Selected**: A binary indicator (true/false) representing whether the player is selected, serving as the decision variable in the optimization model.  

### Current Stored Values  
```sql
-- Iteration 2 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic poker tournament scenarios, ensuring diversity in nationalities and a mix of money ranks to make the optimization problem meaningful.

-- Realistic data for poker_player
INSERT INTO poker_player (Earnings, Money_Rank, Selected, Nationality) VALUES (1200.0, 45, False, 'USA');
INSERT INTO poker_player (Earnings, Money_Rank, Selected, Nationality) VALUES (1500.0, 55, False, 'Canada');
INSERT INTO poker_player (Earnings, Money_Rank, Selected, Nationality) VALUES (2000.0, 60, False, 'UK');
INSERT INTO poker_player (Earnings, Money_Rank, Selected, Nationality) VALUES (1000.0, 50, False, 'Australia');
INSERT INTO poker_player (Earnings, Money_Rank, Selected, Nationality) VALUES (1800.0, 58, False, 'Germany');

-- Realistic data for player_selection
INSERT INTO player_selection (Player_ID, Selected) VALUES (1, False);
INSERT INTO player_selection (Player_ID, Selected) VALUES (2, False);
INSERT INTO player_selection (Player_ID, Selected) VALUES (3, False);
INSERT INTO player_selection (Player_ID, Selected) VALUES (4, False);
INSERT INTO player_selection (Player_ID, Selected) VALUES (5, False);
```