# Complete Optimization Problem and Solution: program_share

## 1. Problem Context and Goals

### Context  
A media company is focused on maximizing its total viewership share across multiple channels by strategically scheduling programs. The company must decide which programs to broadcast on which channels and at what times of day. This decision is guided by two key operational metrics: the share of viewership each program attracts on a specific channel and the overall rating of the channel itself. The goal is to ensure that the scheduling decisions are made in a way that maximizes the combined impact of these metrics.

The company operates under specific business rules:  
1. Each program can be broadcast at most once across all channels and time slots.  
2. Each channel has a maximum number of time slots available for broadcasting, currently set to 5.  
3. Each channel must broadcast a minimum number of local programs, currently set to 2, to comply with regulatory requirements and cater to local audiences.  

These rules ensure that the scheduling process remains balanced and adheres to both operational and regulatory constraints. The decision variables are binary, indicating whether a specific program is scheduled on a particular channel at a given time slot. The objective is to maximize the total viewership share, calculated as the sum of the products of program shares and channel ratings for all scheduled programs.

### Goals  
The primary goal of this optimization problem is to maximize the total viewership share across all channels. This is achieved by selecting the best combination of programs, channels, and time slots, weighted by the program's share of viewership on the channel and the channel's overall rating. Success is measured by the total viewership share generated from the scheduled programs, ensuring that the company's content reaches the largest possible audience while adhering to operational and regulatory constraints.

## 2. Constraints  

The optimization problem is subject to the following constraints:  
1. **Program Uniqueness**: Each program can be broadcast at most once across all channels and time slots. This ensures that no program is over-scheduled, maintaining variety in the programming lineup.  
2. **Channel Time Slot Limit**: Each channel can only use a limited number of time slots for broadcasting, currently capped at 5. This ensures that no channel is overburdened with too many programs, maintaining a balanced schedule.  
3. **Local Program Requirement**: Each channel must broadcast a minimum number of local programs, currently set to 2. This ensures compliance with regulatory requirements and caters to the preferences of local audiences.  

These constraints are designed to ensure that the scheduling decisions are both operationally feasible and aligned with the company's strategic and regulatory goals.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 3 Database Schema
-- Objective: Schema changes include adding tables for Max_Time_Slots and Min_Local_Programs to address missing optimization requirements. Configuration logic updates include scalar parameters for Max_Time_Slots and Min_Local_Programs.

CREATE TABLE time_slots (
  time_slot_id INTEGER,
  time_of_day STRING
);

CREATE TABLE program_origins (
  program_id INTEGER,
  origin STRING
);

CREATE TABLE broadcast_decisions (
  channel_id INTEGER,
  program_id INTEGER,
  time_slot_id INTEGER,
  x BOOLEAN
);

CREATE TABLE program_shares (
  channel_id INTEGER,
  program_id INTEGER,
  share_in_percent INTEGER
);

CREATE TABLE channel_ratings (
  channel_id INTEGER,
  rating_in_percent INTEGER
);
```

### Data Dictionary  
- **time_slots**: Contains available time slots for broadcasting programs.  
  - `time_slot_id`: Unique identifier for a time slot.  
  - `time_of_day`: Time of day for broadcasting (e.g., Morning, Afternoon, Evening).  

- **program_origins**: Indicates the origin of programs (e.g., local, international).  
  - `program_id`: Unique identifier for a program.  
  - `origin`: Origin of the program (e.g., Local, International).  

- **broadcast_decisions**: Represents binary decisions indicating whether a program is broadcast on a channel at a specific time.  
  - `channel_id`: Unique identifier for a channel.  
  - `program_id`: Unique identifier for a program.  
  - `time_slot_id`: Unique identifier for a time slot.  
  - `x`: Binary decision variable (0 or 1).  

- **program_shares**: Contains the share of viewership for a program on a channel.  
  - `channel_id`: Unique identifier for a channel.  
  - `program_id`: Unique identifier for a program.  
  - `share_in_percent`: Share of viewership for the program on the channel.  

- **channel_ratings**: Contains the rating of a channel.  
  - `channel_id`: Unique identifier for a channel.  
  - `rating_in_percent`: Rating of the channel.  

### Current Stored Values  
```sql
-- Iteration 3 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical media industry standards, ensuring realistic viewership shares, channel ratings, and program scheduling constraints. The data was designed to reflect a balanced mix of local and international programs, with varying time slots to maximize viewership.

-- Realistic data for time_slots
INSERT INTO time_slots (time_slot_id, time_of_day) VALUES (1, 'Morning');
INSERT INTO time_slots (time_slot_id, time_of_day) VALUES (2, 'Afternoon');
INSERT INTO time_slots (time_slot_id, time_of_day) VALUES (3, 'Evening');

-- Realistic data for program_origins
INSERT INTO program_origins (program_id, origin) VALUES (1, 'Local');
INSERT INTO program_origins (program_id, origin) VALUES (2, 'International');
INSERT INTO program_origins (program_id, origin) VALUES (3, 'Local');

-- Realistic data for broadcast_decisions
INSERT INTO broadcast_decisions (channel_id, program_id, time_slot_id, x) VALUES (1, 1, 1, 1);
INSERT INTO broadcast_decisions (channel_id, program_id, time_slot_id, x) VALUES (2, 2, 3, 1);
INSERT INTO broadcast_decisions (channel_id, program_id, time_slot_id, x) VALUES (3, 3, 2, 1);

-- Realistic data for program_shares
INSERT INTO program_shares (channel_id, program_id, share_in_percent) VALUES (1, 1, 60);
INSERT INTO program_shares (channel_id, program_id, share_in_percent) VALUES (2, 2, 70);
INSERT INTO program_shares (channel_id, program_id, share_in_percent) VALUES (3, 3, 50);

-- Realistic data for channel_ratings
INSERT INTO channel_ratings (channel_id, rating_in_percent) VALUES (1, 75);
INSERT INTO channel_ratings (channel_id, rating_in_percent) VALUES (2, 85);
INSERT INTO channel_ratings (channel_id, rating_in_percent) VALUES (3, 80);
```