# Complete Optimization Problem and Solution: race_track

## 1. Problem Context and Goals

### Context  
A race track management company is tasked with optimizing the utilization of seating capacity across all its tracks for the upcoming year. The company operates multiple tracks, each with a specific seating capacity and a maximum allowable number of races. The primary business decision involves determining the number of races to be held at each track to maximize the total seating capacity utilization. This decision must respect two key operational constraints: the maximum number of races allowed at each track and the total available seating capacity across all tracks. The total seating capacity is a fixed value determined by the company’s business configuration, ensuring that the overall seating utilization does not exceed the company’s operational limits. The problem is designed to align with linear optimization principles, focusing on straightforward relationships between seating capacities, race counts, and operational constraints without introducing nonlinear complexities.

### Goals  
The optimization goal is to maximize the total seating capacity utilization across all races held at the company’s tracks. This is achieved by strategically determining the number of races at each track, weighted by their respective seating capacities. Success is measured by the total seating utilization, which is the sum of the seating capacity of each track multiplied by the number of races held there. The objective is to ensure that the company’s resources are used efficiently while adhering to operational constraints.

## 2. Constraints  

The optimization problem is subject to two primary constraints:  
1. **Race Limit per Track**: The number of races held at each track cannot exceed the maximum number of races allowed for that track. This ensures that each track operates within its capacity for hosting events.  
2. **Total Seating Capacity**: The total seating utilization across all tracks must not exceed the company’s total available seating capacity. This ensures that the company’s overall seating resources are not overutilized.  

These constraints are designed to align with linear optimization principles, ensuring that the relationships between variables and constraints remain straightforward and avoid nonlinear complexities.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for missing optimization requirements and updating business configuration logic for scalar parameters and formulas.

CREATE TABLE track (
  Seating INTEGER
);

CREATE TABLE track_races (
  Races INTEGER
);

CREATE TABLE track_limits (
  Max_Races INTEGER
);
```

### Data Dictionary  
- **track**: Stores information about each race track.  
  - **Seating**: Represents the seating capacity of the track. This value is used as a coefficient in the optimization objective to calculate total seating utilization.  
- **track_races**: Stores the number of races to be held at each track.  
  - **Races**: Represents the decision variable in the optimization model, determining the number of races at each track.  
- **track_limits**: Stores the maximum number of races allowed per track.  
  - **Max_Races**: Represents the upper bound constraint for the number of races at each track.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic race track capacities, typical race schedules, and operational constraints to ensure a meaningful optimization problem.

-- Realistic data for track
INSERT INTO track (Seating) VALUES (5000);
INSERT INTO track (Seating) VALUES (10000);
INSERT INTO track (Seating) VALUES (15000);

-- Realistic data for track_races
INSERT INTO track_races (Races) VALUES (3);
INSERT INTO track_races (Races) VALUES (5);
INSERT INTO track_races (Races) VALUES (7);

-- Realistic data for track_limits
INSERT INTO track_limits (Max_Races) VALUES (10);
INSERT INTO track_limits (Max_Races) VALUES (12);
INSERT INTO track_limits (Max_Races) VALUES (15);
```