# Complete Optimization Problem and Solution: riding_club

## 1. Problem Context and Goals

### Context  
The riding club operates with the goal of maximizing the total points earned across all clubs in a season. This is achieved by optimally assigning players to coaches based on two key factors: the votes received by each player and the rank of each coach. The assignment of players to coaches is a binary decision, meaning each player is either assigned to a specific coach or not. 

The club has established a business configuration that limits the number of players each coach can handle to a maximum of four. This ensures that coaches can provide adequate attention and support to their assigned players. The votes received by players and the ranks of coaches are used as coefficients in the optimization model to determine the total points earned. 

The optimization problem is designed to be linear, ensuring computational efficiency and scalability. This means that all relationships and constraints are expressed in a straightforward, additive manner without any complex interactions such as variable products or divisions.

### Goals  
The primary goal of the optimization is to maximize the total points earned by all clubs. This is achieved by strategically assigning players to coaches in a way that leverages the coach's rank and the player's votes. The success of the optimization is measured by the total points calculated, which is directly influenced by the combination of player votes and coach ranks for each assignment. 

The optimization process ensures that each player is assigned to exactly one coach and that no coach exceeds their maximum capacity of four players. The goal is to find the optimal assignment that maximizes the overall points while adhering to these constraints.

## 2. Constraints    

The optimization problem is subject to two main constraints:

1. **Single Assignment Constraint**: Each player must be assigned to exactly one coach. This ensures that no player is left without a coach or assigned to multiple coaches simultaneously.

2. **Coach Capacity Constraint**: Each coach can handle a maximum of four players. This ensures that coaches are not overwhelmed and can provide adequate attention to each player assigned to them.

These constraints are designed to be linear, meaning they are expressed in a straightforward, additive manner without any complex interactions. This ensures that the optimization problem remains computationally efficient and scalable.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for missing optimization requirements and updating business configuration logic to handle scalar parameters and formulas.

CREATE TABLE player (
  Player_ID INTEGER,
  Votes INTEGER
);

CREATE TABLE coach (
  Coach_ID INTEGER,
  Rank INTEGER
);

CREATE TABLE assignment (
  Player_ID INTEGER,
  Coach_ID INTEGER,
  Assignment BOOLEAN
);
```

### Data Dictionary  
- **Player Table**: Represents the players in the riding club. Each player has a unique identifier (`Player_ID`) and a number of votes (`Votes`) they have received. The votes are used as coefficients in the objective function to calculate the total points.
  
- **Coach Table**: Represents the coaches in the riding club. Each coach has a unique identifier (`Coach_ID`) and a rank (`Rank`). The rank is used as a coefficient in the objective function to calculate the total points.
  
- **Assignment Table**: Represents the assignment of players to coaches. Each record indicates whether a specific player (`Player_ID`) is assigned to a specific coach (`Coach_ID`). The assignment is a binary decision variable in the optimization model.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic scenarios in a riding club, considering player votes, coach ranks, and the maximum number of players a coach can handle. The data ensures a balanced distribution of players and coaches, enabling a meaningful optimization problem.

-- Realistic data for player
INSERT INTO player (Player_ID, Votes) VALUES (1, 12);
INSERT INTO player (Player_ID, Votes) VALUES (2, 18);
INSERT INTO player (Player_ID, Votes) VALUES (3, 9);

-- Realistic data for coach
INSERT INTO coach (Coach_ID, Rank) VALUES (1, 3);
INSERT INTO coach (Coach_ID, Rank) VALUES (2, 2);
INSERT INTO coach (Coach_ID, Rank) VALUES (3, 1);

-- Realistic data for assignment
INSERT INTO assignment (Player_ID, Coach_ID, Assignment) VALUES (1, 1, False);
INSERT INTO assignment (Player_ID, Coach_ID, Assignment) VALUES (2, 2, True);
INSERT INTO assignment (Player_ID, Coach_ID, Assignment) VALUES (3, 3, False);
```