# Complete Optimization Problem and Solution: school_player

## 1. Problem Context and Goals

### Context  
The optimization problem focuses on allocating players to schools in a way that maximizes the overall performance of school sports teams. Each school has specific enrollment limits, and each team must adhere to position constraints to ensure balanced and effective team compositions. The decision to assign a player to a school is binary, meaning a player is either assigned to a school or not.  

The performance weight for each school and position is calculated based on the school's historical performance and the importance of the position. This weight is used to evaluate the contribution of assigning a player to a school. The business configuration includes:  
- A minimum team size of 11 players, ensuring that each school has enough players to form a complete team.  
- Minimum and maximum player requirements for each position, ensuring that teams have adequate coverage and flexibility. For example, a team must have at least 2 players and no more than 5 players in the "Forward" position.  

The performance weight is derived by multiplying the school's historical performance score by the position weight, ensuring that the objective function reflects both the school's capabilities and the strategic importance of each position.  

### Goals  
The primary goal of this optimization is to maximize the overall performance of all school teams. This is achieved by assigning players to schools in a way that aligns with the schools' historical performance and the players' positions. Success is measured by the total performance weight across all assignments, ensuring that the best possible team compositions are achieved while adhering to enrollment limits and position constraints.  

## 2. Constraints  

The optimization problem must adhere to the following constraints:  
1. **School Enrollment Limits**: The total number of players assigned to a school cannot exceed the school's enrollment capacity. For example, if a school can enroll up to 25 players, the sum of all player assignments to that school must be less than or equal to 25.  
2. **Position Constraints**: Each school must have a minimum and maximum number of players in each position. For instance, a school must have at least 2 players and no more than 5 players in the "Forward" position.  
3. **Minimum Team Size**: Each school must have at least 11 players assigned to form a complete team.  

These constraints ensure that the team compositions are feasible, balanced, and aligned with operational requirements.  

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating tables for performance weights, position constraints, and team size requirements. Configuration logic updates include scalar parameters for minimum team size and position constraints, and formulas for performance weight calculations.

CREATE TABLE performance_weight (
  school_id INTEGER,
  position STRING,
  weight FLOAT
);

CREATE TABLE position_constraints (
  position STRING,
  min_players INTEGER,
  max_players INTEGER
);

CREATE TABLE school (
  school_id INTEGER,
  enrollment INTEGER,
  historical_performance FLOAT
);

CREATE TABLE player_assignment (
  player_id INTEGER,
  school_id INTEGER,
  assigned BOOLEAN
);
```

### Data Dictionary  
- **performance_weight**: Stores the performance weights for schools based on positions.  
  - `school_id`: Unique identifier for the school.  
  - `position`: Player position (e.g., Forward, Midfielder, Defender).  
  - `weight`: Performance weight for the school in the specified position, used in the objective function.  
- **position_constraints**: Stores the minimum and maximum number of players allowed in each position.  
  - `position`: Player position.  
  - `min_players`: Minimum number of players required in the position, used in position constraints.  
  - `max_players`: Maximum number of players allowed in the position, used in position constraints.  
- **school**: Stores school information, including enrollment capacity and historical performance.  
  - `school_id`: Unique identifier for the school.  
  - `enrollment`: Maximum number of players a school can enroll, used in enrollment constraints.  
  - `historical_performance`: Historical performance score of the school, used in performance weight calculation.  
- **player_assignment**: Stores the assignment of players to schools.  
  - `player_id`: Unique identifier for the player.  
  - `school_id`: Unique identifier for the school.  
  - `assigned`: Indicates if the player is assigned to the school, used as the decision variable.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic school sports team sizes, historical performance data, and typical position constraints in team sports. The data ensures that the optimization problem is meaningful and solvable by aligning with real-world scenarios.

-- Realistic data for performance_weight
INSERT INTO performance_weight (school_id, position, weight) VALUES (1, 'Forward', 0.9);
INSERT INTO performance_weight (school_id, position, weight) VALUES (1, 'Midfielder', 0.8);
INSERT INTO performance_weight (school_id, position, weight) VALUES (1, 'Defender', 0.7);
INSERT INTO performance_weight (school_id, position, weight) VALUES (2, 'Forward', 0.8);
INSERT INTO performance_weight (school_id, position, weight) VALUES (2, 'Midfielder', 0.9);
INSERT INTO performance_weight (school_id, position, weight) VALUES (2, 'Defender', 0.8);
INSERT INTO performance_weight (school_id, position, weight) VALUES (3, 'Forward', 0.7);
INSERT INTO performance_weight (school_id, position, weight) VALUES (3, 'Midfielder', 0.8);
INSERT INTO performance_weight (school_id, position, weight) VALUES (3, 'Defender', 0.9);

-- Realistic data for position_constraints
INSERT INTO position_constraints (position, min_players, max_players) VALUES ('Forward', 2, 4);
INSERT INTO position_constraints (position, min_players, max_players) VALUES ('Midfielder', 3, 5);
INSERT INTO position_constraints (position, min_players, max_players) VALUES ('Defender', 3, 5);

-- Realistic data for school
INSERT INTO school (school_id, enrollment, historical_performance) VALUES (1, 25, 0.9);
INSERT INTO school (school_id, enrollment, historical_performance) VALUES (2, 20, 0.8);
INSERT INTO school (school_id, enrollment, historical_performance) VALUES (3, 30, 0.7);

-- Realistic data for player_assignment
INSERT INTO player_assignment (player_id, school_id, assigned) VALUES (1, 1, False);
INSERT INTO player_assignment (player_id, school_id, assigned) VALUES (2, 2, True);
INSERT INTO player_assignment (player_id, school_id, assigned) VALUES (3, 3, False);
INSERT INTO player_assignment (player_id, school_id, assigned) VALUES (4, 1, True);
INSERT INTO player_assignment (player_id, school_id, assigned) VALUES (5, 2, False);
INSERT INTO player_assignment (player_id, school_id, assigned) VALUES (6, 3, True);
INSERT INTO player_assignment (player_id, school_id, assigned) VALUES (7, 1, False);
INSERT INTO player_assignment (player_id, school_id, assigned) VALUES (8, 2, True);
INSERT INTO player_assignment (player_id, school_id, assigned) VALUES (9, 3, False);
INSERT INTO player_assignment (player_id, school_id, assigned) VALUES (10, 1, True);
```