# Complete Optimization Problem and Solution: ship_1

## 1. Problem Context and Goals

### Context  
A shipping company is focused on optimizing the assignment of captains to ships to minimize operational costs while ensuring efficient fleet management. The company must decide which captain to assign to each ship, considering factors such as the captain's rank, the ship's type, and the ship's age. Each ship must be assigned exactly one captain, and each captain can be assigned to at most one ship. Additionally, the assignment must respect compatibility rules between captain ranks and ship types, as well as age restrictions based on the ship's age and the captain's rank.

The cost of assigning a captain to a ship is determined by operational expenses, which vary depending on the captain's rank and the ship's type and age. The company has predefined rules to ensure compatibility between captains and ships, as well as age allowances that dictate whether a ship's age is acceptable for a captain's rank. These rules are critical for maintaining safety and operational efficiency.

The business configuration includes a scalar parameter for the cost of assigning a captain to a ship, which is used in the objective function to minimize total costs. Additionally, business logic formulas are used to determine compatibility between captains and ships and to enforce age restrictions. These formulas ensure that assignments are both cost-effective and compliant with operational standards.

### Goals  
The primary goal of this optimization problem is to minimize the total cost of assigning captains to ships. This cost is calculated based on the operational expenses associated with each possible assignment. Success is measured by achieving the lowest possible total cost while ensuring that all ships are assigned a captain, no captain is over-assigned, and all compatibility and age constraints are satisfied.

## 2. Constraints  

The optimization problem must adhere to the following constraints:  
1. **Ship Assignment Constraint**: Each ship must be assigned exactly one captain. This ensures that all ships are operational and no ship is left without a captain.  
2. **Captain Assignment Constraint**: Each captain can be assigned to at most one ship. This prevents over-assignment and ensures that captains are not stretched too thin.  
3. **Compatibility Constraint**: A captain can only be assigned to a ship if their rank is compatible with the ship's type. This ensures that captains are qualified to operate the ships they are assigned to.  
4. **Age Constraint**: A captain can only be assigned to a ship if the ship's age is acceptable for their rank. This ensures that safety and operational standards are maintained based on the ship's age and the captain's experience level.  

These constraints are designed to ensure that the assignments are both feasible and compliant with the company's operational requirements.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating tables for cost coefficients, compatibility rules, and age rules. Configuration logic updates include scalar parameters for cost coefficients and formulas for compatibility and age rules.

CREATE TABLE cost_coefficients (
  captain_id INTEGER,
  ship_id INTEGER,
  cost_value INTEGER,
  assign_flag BOOLEAN
);

CREATE TABLE compatibility_rules (
  captain_rank STRING,
  ship_type STRING,
  is_compatible BOOLEAN
);

CREATE TABLE age_rules (
  captain_rank STRING,
  ship_age INTEGER,
  is_allowed BOOLEAN
);
```

### Data Dictionary  
- **cost_coefficients**:  
  - **Business Purpose**: Stores the cost of assigning a captain to a ship based on their rank, the ship's type, and the ship's age.  
  - **Optimization Role**: Provides the coefficients for the objective function, which aims to minimize total assignment costs.  
  - **Columns**:  
    - `captain_id`: Unique identifier for a captain.  
    - `ship_id`: Unique identifier for a ship.  
    - `cost_value`: The cost of assigning the captain to the ship.  
    - `assign_flag`: Indicates whether the captain is assigned to the ship (used as a binary decision variable).  

- **compatibility_rules**:  
  - **Business Purpose**: Defines whether a captain's rank is compatible with a ship's type.  
  - **Optimization Role**: Used in constraints to ensure that assignments are compatible.  
  - **Columns**:  
    - `captain_rank`: The rank of the captain (e.g., Junior, Senior).  
    - `ship_type`: The type of the ship (e.g., Cargo, Passenger).  
    - `is_compatible`: Indicates whether the captain's rank is compatible with the ship's type.  

- **age_rules**:  
  - **Business Purpose**: Determines whether a ship's age is acceptable for a captain's rank.  
  - **Optimization Role**: Used in constraints to enforce age-related restrictions.  
  - **Columns**:  
    - `captain_rank`: The rank of the captain.  
    - `ship_age`: The age of the ship.  
    - `is_allowed`: Indicates whether the ship's age is acceptable for the captain's rank.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical shipping industry standards, considering captain ranks, ship types, and ages. Costs were set to reflect operational expenses, compatibility rules were based on industry norms, and age allowances were aligned with safety regulations.

-- Realistic data for cost_coefficients
INSERT INTO cost_coefficients (captain_id, ship_id, cost_value, assign_flag) VALUES (1, 1, 1200, False);
INSERT INTO cost_coefficients (captain_id, ship_id, cost_value, assign_flag) VALUES (2, 2, 1500, False);
INSERT INTO cost_coefficients (captain_id, ship_id, cost_value, assign_flag) VALUES (3, 3, 1000, False);

-- Realistic data for compatibility_rules
INSERT INTO compatibility_rules (captain_rank, ship_type, is_compatible) VALUES ('Junior', 'Cargo', True);
INSERT INTO compatibility_rules (captain_rank, ship_type, is_compatible) VALUES ('Senior', 'Passenger', True);
INSERT INTO compatibility_rules (captain_rank, ship_type, is_compatible) VALUES ('Junior', 'Passenger', False);

-- Realistic data for age_rules
INSERT INTO age_rules (captain_rank, ship_age, is_allowed) VALUES ('Junior', 5, True);
INSERT INTO age_rules (captain_rank, ship_age, is_allowed) VALUES ('Senior', 15, True);
INSERT INTO age_rules (captain_rank, ship_age, is_allowed) VALUES ('Junior', 15, False);
```