# Complete Optimization Problem and Solution: singer

## 1. Problem Context and Goals

### Context  
A music label is tasked with selecting a subset of singers to promote in order to maximize the total sales of their songs. The label must make these decisions while adhering to two key operational constraints: the total budget available for promotions and the maximum number of singers that can be effectively promoted. 

The decision to promote a singer is represented as a binary choice: either the singer is selected for promotion or they are not. The total sales of songs associated with the selected singers will be used to measure the success of the promotion strategy. The label has a fixed budget of 500,000 units, which limits the total net worth of the singers that can be promoted. Additionally, the label can promote no more than 3 singers at a time to ensure effective resource allocation and promotional impact.

### Goals  
The primary goal of this optimization problem is to maximize the total sales of songs by selecting the optimal set of singers for promotion. Success is measured by the cumulative sales of the songs associated with the selected singers. The label aims to achieve this goal while staying within the constraints of the available budget and the maximum number of singers that can be promoted.

## 2. Constraints  

1. **Budget Constraint**: The total net worth of the singers selected for promotion must not exceed the available budget of 500,000 units. This ensures that the label does not overspend on promotional activities.  
2. **Promotional Capacity Constraint**: The label can promote a maximum of 3 singers at a time. This ensures that the promotional efforts are focused and manageable, avoiding resource overextension.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating a new table for decision variables and updating the song table to include sales data. Configuration logic updates include adding scalar parameters for Total_Budget and Max_Singers.

CREATE TABLE singer_selection (
  singer_id INTEGER,
  is_selected BOOLEAN
);

CREATE TABLE song (
  song_id INTEGER,
  singer_id INTEGER,
  Sales INTEGER
);
```

### Data Dictionary  
- **singer_selection**:  
  - **Business Purpose**: Represents the selection of singers for promotion.  
  - **Optimization Role**: Decision variables indicating whether a singer is selected.  
  - **Columns**:  
    - **singer_id**: Unique identifier for each singer. Links to the singer being considered for selection.  
    - **is_selected**: Binary indicator of whether the singer is selected for promotion.  

- **song**:  
  - **Business Purpose**: Represents the songs and their sales data.  
  - **Optimization Role**: Provides the sales data used to measure the success of the promotion strategy.  
  - **Columns**:  
    - **song_id**: Unique identifier for each song.  
    - **singer_id**: Identifier for the singer of the song. Links the song to the singer.  
    - **Sales**: Sales of the song. Used as the objective coefficient in the optimization problem.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic business scenarios, considering typical budgets for music promotions, average song sales, and the number of singers a label can effectively promote.

-- Realistic data for singer_selection
INSERT INTO singer_selection (singer_id, is_selected) VALUES (1, False);
INSERT INTO singer_selection (singer_id, is_selected) VALUES (2, True);
INSERT INTO singer_selection (singer_id, is_selected) VALUES (3, False);

-- Realistic data for song
INSERT INTO song (song_id, singer_id, Sales) VALUES (1, 1, 1500);
INSERT INTO song (song_id, singer_id, Sales) VALUES (2, 2, 2500);
INSERT INTO song (song_id, singer_id, Sales) VALUES (3, 3, 1000);
```