# Complete Optimization Problem and Solution: station_weather

## 1. Problem Context and Goals

### Context  
The optimization problem focuses on improving train scheduling to minimize total travel time while accounting for weather-related delays at stations along the route. The decision variable is the total travel time for each train, which is a continuous value. The objective is to minimize the sum of these travel times across all trains. Weather conditions, specifically precipitation and wind speed, linearly affect train delays. Precipitation increases delays by a factor of 0.1, and wind speed increases delays by a factor of 0.05, as determined by business configuration parameters. These factors are applied to the precipitation and wind speed values recorded at each station. The model ensures that trains operate within safe and feasible travel time limits, avoiding scenarios that would require nonlinear relationships such as variable products or divisions. The data used includes base travel times, maximum allowed travel times, and current weather conditions at each station, all of which are mapped to specific trains and stations.

### Goals  
The primary goal of this optimization is to minimize the total travel time for all trains. This is achieved by adjusting train schedules to account for weather-related delays while ensuring that travel times remain within operational limits. Success is measured by the reduction in the sum of total travel times across all trains, using realistic data for base travel times, maximum travel times, and weather conditions. The optimization ensures that all constraints are met without introducing nonlinear relationships, maintaining a linear formulation throughout.

## 2. Constraints  

The optimization problem includes two key constraints:  
1. **Minimum Travel Time Constraint**: The total travel time for each train must be at least equal to the base travel time plus the delays caused by precipitation and wind speed. Precipitation delays are calculated by multiplying the precipitation at each station by the precipitation factor (0.1), and wind speed delays are calculated by multiplying the wind speed at each station by the wind factor (0.05).  
2. **Maximum Travel Time Constraint**: The total travel time for each train must not exceed the maximum allowed travel time, ensuring that trains operate within safe and feasible limits.  

These constraints are designed to ensure that the optimization model remains linear and avoids scenarios that would require nonlinear relationships.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for base and max travel times, and updating configuration logic for precipitation and wind factors. Business configuration logic now includes scalar parameters and formulas for optimization.

CREATE TABLE train_travel_times (
  train_id INTEGER,
  base_travel_time FLOAT,
  max_travel_time FLOAT,
  total_travel_time FLOAT,
  delay FLOAT
);

CREATE TABLE weekly_weather (
  station_id INTEGER,
  precipitation FLOAT,
  wind_speed_mph FLOAT
);
```

### Data Dictionary  
- **train_travel_times**:  
  - **train_id**: Unique identifier for each train, used to map travel times to specific trains.  
  - **base_travel_time**: The base travel time for each train without delays, used in travel time constraints.  
  - **max_travel_time**: The maximum allowed travel time for each train, used in travel time constraints.  
  - **total_travel_time**: The total travel time for each train including delays, used in the objective function.  
  - **delay**: The delay at each station for each train, used in delay constraints.  

- **weekly_weather**:  
  - **station_id**: Unique identifier for each station, used to map weather conditions to specific stations.  
  - **precipitation**: The precipitation at each station, used in delay calculation for precipitation.  
  - **wind_speed_mph**: The wind speed at each station, used in delay calculation for wind speed.  

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic train travel times and weather conditions, ensuring they align with typical operational scenarios and optimization constraints.

-- Realistic data for train_travel_times
INSERT INTO train_travel_times (train_id, base_travel_time, max_travel_time, total_travel_time, delay) VALUES (1, 120.0, 200.0, 130.0, 5.0);
INSERT INTO train_travel_times (train_id, base_travel_time, max_travel_time, total_travel_time, delay) VALUES (2, 150.0, 250.0, 160.0, 10.0);
INSERT INTO train_travel_times (train_id, base_travel_time, max_travel_time, total_travel_time, delay) VALUES (3, 180.0, 300.0, 190.0, 15.0);

-- Realistic data for weekly_weather
INSERT INTO weekly_weather (station_id, precipitation, wind_speed_mph) VALUES (1, 0.5, 10.0);
INSERT INTO weekly_weather (station_id, precipitation, wind_speed_mph) VALUES (2, 1.0, 15.0);
INSERT INTO weekly_weather (station_id, precipitation, wind_speed_mph) VALUES (3, 1.5, 20.0);
```