# Complete Optimization Problem and Solution: wedding

## 1. Problem Context and Goals

### Context  
A wedding planning company is tasked with organizing weddings across multiple churches each year. The company aims to minimize the total cost of these weddings while ensuring that each church operates within its capacity and that the total number of weddings per year does not exceed a predefined limit. The key decision involves determining the number of weddings to hold at each church each year, considering the cost of organizing a wedding at each church and the operational constraints.

The cost of organizing a wedding varies by church and year, and these costs are known and fixed. Each church has a maximum capacity for the number of weddings it can handle annually, ensuring that the quality of service is maintained. Additionally, there is a company-wide limit on the total number of weddings that can be organized each year, reflecting the overall operational capacity.

The business configuration includes two critical parameters: the maximum number of weddings allowed per year, which is set to 120, and the maximum number of weddings a single church can handle, which is set to 30. These parameters ensure that the company operates within realistic and sustainable limits.

### Goals  
The primary goal of the optimization is to minimize the total cost of organizing weddings across all churches and years. This is achieved by strategically deciding how many weddings to hold at each church each year, considering the cost per wedding at each location and the operational constraints. Success is measured by achieving the lowest possible total cost while adhering to the capacity limits of each church and the overall annual limit on weddings.

## 2. Constraints    

The optimization problem is subject to two main constraints:

1. **Annual Wedding Limit**: The total number of weddings organized across all churches in a given year must not exceed the maximum number of weddings allowed per year, which is 120. This ensures that the company does not overextend its operational capacity in any single year.

2. **Church Capacity Limit**: The number of weddings held at each church in a given year must not exceed the maximum number of weddings that the church can handle, which is 30. This ensures that each church operates within its capacity, maintaining the quality of service for each wedding.

These constraints ensure that the company operates within realistic and sustainable limits while minimizing costs.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating tables for cost per wedding, church capacity, and maximum weddings per year. Business configuration logic updated with scalar parameters and formulas for optimization.

CREATE TABLE cost_per_wedding (
  church_id INTEGER,
  year INTEGER,
  cost FLOAT
);

CREATE TABLE weddings (
  church_id INTEGER,
  year INTEGER,
  number_of_weddings INTEGER
);
```

### Data Dictionary  
- **cost_per_wedding**: This table contains the cost of organizing a wedding at a specific church in a specific year. The cost is used as a coefficient in the objective function to calculate the total cost of weddings.
  - **church_id**: Unique identifier for the church.
  - **year**: Year of the wedding.
  - **cost**: Cost of organizing a wedding at the specified church and year.

- **weddings**: This table contains the number of weddings held at each church each year. This data represents the decision variables in the optimization model.
  - **church_id**: Unique identifier for the church.
  - **year**: Year of the wedding.
  - **number_of_weddings**: Number of weddings held at the specified church and year.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on industry standards, realistic church capacities, and typical wedding costs. The data ensures that the optimization problem is meaningful and solvable by balancing costs, capacities, and constraints.

-- Realistic data for cost_per_wedding
INSERT INTO cost_per_wedding (church_id, year, cost) VALUES (1, 2023, 5000.0);
INSERT INTO cost_per_wedding (church_id, year, cost) VALUES (2, 2023, 4500.0);
INSERT INTO cost_per_wedding (church_id, year, cost) VALUES (3, 2023, 6000.0);
INSERT INTO cost_per_wedding (church_id, year, cost) VALUES (1, 2024, 5200.0);
INSERT INTO cost_per_wedding (church_id, year, cost) VALUES (2, 2024, 4600.0);
INSERT INTO cost_per_wedding (church_id, year, cost) VALUES (3, 2024, 6100.0);

-- Realistic data for weddings
INSERT INTO weddings (church_id, year, number_of_weddings) VALUES (1, 2023, 10);
INSERT INTO weddings (church_id, year, number_of_weddings) VALUES (2, 2023, 15);
INSERT INTO weddings (church_id, year, number_of_weddings) VALUES (3, 2023, 8);
INSERT INTO weddings (church_id, year, number_of_weddings) VALUES (1, 2024, 12);
INSERT INTO weddings (church_id, year, number_of_weddings) VALUES (2, 2024, 16);
INSERT INTO weddings (church_id, year, number_of_weddings) VALUES (3, 2024, 9);
```