# Complete Optimization Problem and Solution: wta_1

## 1. Problem Context and Goals

### Context  
The business problem revolves around optimizing the scheduling of players across various tournaments to maximize the total ranking points earned. This involves making decisions about which players should participate in which tournaments, considering their availability, the maximum number of tournaments each player can participate in, and the maximum number of players allowed in each tournament. 

The decision to be made is whether a specific player participates in a specific tournament, represented as a binary choice. The operational parameters include the ranking points each player can earn in each tournament, which directly influence the objective of maximizing the total points. 

Business configuration parameters play a crucial role in defining the constraints. For instance, each player is limited to participating in a maximum of five tournaments to balance their schedule and performance. Additionally, each tournament has a cap on the total ranking points that can be earned, set at 2000 points, to reflect realistic point distributions.

### Goals  
The primary goal of this optimization is to maximize the total ranking points earned by players across all tournaments. This is achieved by strategically deciding which players participate in which tournaments, ensuring that the constraints on player participation and tournament capacity are respected. Success is measured by the total ranking points accumulated, which directly ties back to the operational data on ranking points earned by players in specific tournaments.

## 2. Constraints    

The optimization problem is subject to several constraints that ensure the decisions made are feasible and align with business rules:

1. **Player Participation Limit**: Each player can participate in a maximum of five tournaments. This constraint ensures that players are not over-scheduled, balancing their performance and well-being.

2. **Tournament Capacity Limit**: Each tournament has a maximum number of players that can participate. This constraint ensures that the tournaments do not exceed their capacity, maintaining the quality and manageability of the events.

3. **Player Availability**: A player can only participate in a tournament if they are available. This constraint ensures that the scheduling respects the availability status of each player, preventing unrealistic or impossible assignments.

These constraints are designed to be linear, ensuring that the optimization problem remains straightforward and solvable using linear or mixed-integer optimization techniques.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Schema changes include creating a new table for ranking points, modifying existing tables to align with OR expert's mapping, and updating business configuration logic for scalar parameters and formulas.

CREATE TABLE player_availability (
  player_id INTEGER,
  availability BOOLEAN
);

CREATE TABLE player_tournament_participation (
  player_id INTEGER,
  tournament_id INTEGER,
  participation BOOLEAN
);

CREATE TABLE matches (
  match_id INTEGER,
  tournament_id INTEGER,
  draw_size INTEGER,
  max_players_per_tournament INTEGER
);

CREATE TABLE player_tournament_ranking_points (
  player_id INTEGER,
  tournament_id INTEGER,
  ranking_points INTEGER
);
```

### Data Dictionary  
- **player_availability**: Tracks whether players are available to participate in tournaments. The `player_id` uniquely identifies each player, and the `availability` column indicates their participation status.
  
- **player_tournament_participation**: Represents the decision of whether a player participates in a specific tournament. The `player_id` and `tournament_id` link the participation to specific players and tournaments, while the `participation` column is the binary decision variable.

- **matches**: Contains details about matches in tournaments. The `tournament_id` links matches to specific tournaments, and the `max_players_per_tournament` column specifies the maximum number of players allowed in each tournament.

- **player_tournament_ranking_points**: Records the ranking points earned by players in specific tournaments. The `player_id` and `tournament_id` link the points to specific players and tournaments, and the `ranking_points` column provides the points earned, which are used as coefficients in the objective function.

### Current Stored Values  
```sql
-- Iteration 2 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on realistic tournament scheduling, player availability, and ranking points allocation, ensuring that the optimization problem remains meaningful and solvable.

-- Realistic data for player_availability
INSERT INTO player_availability (player_id, availability) VALUES (1, True);
INSERT INTO player_availability (player_id, availability) VALUES (2, False);
INSERT INTO player_availability (player_id, availability) VALUES (3, True);

-- Realistic data for player_tournament_participation
INSERT INTO player_tournament_participation (player_id, tournament_id, participation) VALUES (1, 101, True);
INSERT INTO player_tournament_participation (player_id, tournament_id, participation) VALUES (2, 102, False);
INSERT INTO player_tournament_participation (player_id, tournament_id, participation) VALUES (3, 103, True);

-- Realistic data for matches
INSERT INTO matches (match_id, tournament_id, draw_size, max_players_per_tournament) VALUES (1001, 101, 32, 32);
INSERT INTO matches (match_id, tournament_id, draw_size, max_players_per_tournament) VALUES (1002, 102, 64, 64);
INSERT INTO matches (match_id, tournament_id, draw_size, max_players_per_tournament) VALUES (1003, 103, 128, 128);

-- Realistic data for player_tournament_ranking_points
INSERT INTO player_tournament_ranking_points (player_id, tournament_id, ranking_points) VALUES (1, 101, 100);
INSERT INTO player_tournament_ranking_points (player_id, tournament_id, ranking_points) VALUES (2, 102, 200);
INSERT INTO player_tournament_ranking_points (player_id, tournament_id, ranking_points) VALUES (3, 103, 300);
```