# Complete Optimization Problem and Solution: architecture

## 1. Problem Context and Goals

### Context  
An architectural firm is focused on optimizing the allocation of its architects to various projects, specifically bridges and mills. The firm aims to make strategic decisions regarding which architects are assigned to which projects, with the decision variables being binary indicators: x_ij for bridge assignments and y_ik for mill assignments. The operational goal is to maximize the total length of bridges constructed and the number of mills designed. This is achieved by leveraging the firm's resources efficiently, ensuring that each architect does not exceed their capacity to handle projects. The business configuration includes a maximum number of projects an architect can handle, which serves as a constraint to ensure workload balance. Additionally, the total number of mills being designed is considered to align with the firm's strategic focus on mill projects. The firm uses current operational data to inform these decisions, ensuring that the optimization process is grounded in realistic business scenarios. The constraints are linear, focusing on resource limitations and project assignments, avoiding any nonlinear relationships.

### Goals  
The primary goal of the optimization process is to maximize the firm's output in terms of bridge lengths and mill designs. The metric for optimization is the combined total of the lengths of bridges and the number of mills designed, weighted by their respective decision variables. Success is measured by the ability to allocate architects in a way that maximizes these outputs, using the available data and business configuration parameters. The optimization goal is clearly defined in linear terms, focusing on maximizing the sum of the lengths of bridges and the number of mills designed, without involving complex mathematical expressions.

## 2. Constraints    

The optimization process is subject to several key constraints that ensure the feasibility and efficiency of project assignments:

- Each architect can handle a limited number of projects, with the total number of bridge and mill assignments for each architect not exceeding the maximum capacity defined in the business configuration.
- Every bridge project must be assigned to exactly one architect, ensuring that all bridge projects are covered without overlap.
- Similarly, each mill project must be assigned to exactly one architect, guaranteeing that all mill projects are adequately managed.

These constraints are expressed in straightforward business terms, aligning with the linear mathematical formulation required for the optimization process.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for missing mappings and updating configuration logic for scalar parameters and formulas.

CREATE TABLE bridge (
  bridge_id INTEGER,
  length_meters FLOAT,
  architect_id INTEGER
);

CREATE TABLE architect_assignments (
  architect_id INTEGER,
  bridge_id INTEGER,
  mill_id INTEGER
);

CREATE TABLE mills (
  mill_id INTEGER,
  designed BOOLEAN
);
```

### Data Dictionary  
The data dictionary provides a comprehensive overview of the business purposes and optimization roles of the tables and columns used in the optimization process:

- **Bridge Table**: This table stores information about each bridge project, including its unique identifier, length in meters, and the architect assigned to it. The length of the bridge serves as a coefficient in the objective function, contributing to the optimization goal of maximizing bridge lengths.

- **Architect Assignments Table**: This table tracks the assignments of architects to both bridge and mill projects. It includes identifiers for architects, bridges, and mills, serving as the basis for the decision variables in the optimization model. The binary nature of these assignments aligns with the decision variables x_ij and y_ik.

- **Mills Table**: This table contains information about mill projects, specifically whether a mill has been designed. The designed status acts as an indicator in the objective function, contributing to the optimization goal of maximizing the number of mills designed.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical project sizes and architect workloads in the industry, ensuring a balance between bridge lengths and mill designs to maximize the objective function.

-- Realistic data for bridge
INSERT INTO bridge (bridge_id, length_meters, architect_id) VALUES (1, 150.0, 1);
INSERT INTO bridge (bridge_id, length_meters, architect_id) VALUES (2, 250.0, 2);
INSERT INTO bridge (bridge_id, length_meters, architect_id) VALUES (3, 180.0, 3);

-- Realistic data for architect_assignments
INSERT INTO architect_assignments (architect_id, bridge_id, mill_id) VALUES (1, 1, 1);
INSERT INTO architect_assignments (architect_id, bridge_id, mill_id) VALUES (2, 2, 2);
INSERT INTO architect_assignments (architect_id, bridge_id, mill_id) VALUES (3, 3, 3);

-- Realistic data for mills
INSERT INTO mills (mill_id, designed) VALUES (1, True);
INSERT INTO mills (mill_id, designed) VALUES (2, True);
INSERT INTO mills (mill_id, designed) VALUES (3, False);
```