# Complete Optimization Problem and Solution: candidate_poll

## 1. Problem Context and Goals

### Context  
In the dynamic environment of a political campaign, strategic allocation of resources is crucial to maximize support across various poll sources. The campaign team is tasked with deciding how much effort to allocate to each poll source. These decisions are represented by the variable effort[i], which is continuous for each poll source i. The primary objective is to maximize the overall support rate, which is achieved by effectively distributing the available resources. The total support rate is calculated by summing the product of the effort allocated to each poll source and its respective support rate. The campaign operates under a fixed budget, which serves as a constraint on the total resources that can be allocated. This budget is a scalar parameter, ensuring that the allocation strategy remains within the financial limits of the campaign. The business configuration includes this total resource availability, which is a critical factor in the decision-making process. The campaign must adhere to linear constraints, ensuring that the allocation of effort does not exceed the available resources and that each poll source receives an effort within its specified minimum and maximum limits.

### Goals  
The primary goal of the optimization process is to maximize the total support rate for the campaign. This involves strategically allocating resources to various poll sources to achieve the highest possible support rate. The success of this optimization is measured by the total support rate, which is the sum of the products of effort and support rate for each poll source. The objective is clearly defined in linear terms, focusing on maximizing the overall support rate without involving complex mathematical operations.

## 2. Constraints    

The optimization process is subject to several linear constraints that ensure the feasibility and effectiveness of the resource allocation strategy. The total effort allocated across all poll sources must not exceed the total available resources, which is a fixed budget constraint. Additionally, each poll source has specific minimum and maximum effort limits that must be respected. These constraints ensure that the allocation strategy is both practical and aligned with the campaign's operational capabilities. The constraints are expressed in straightforward business terms, emphasizing the linear nature of the relationships involved.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Schema changes include creating a new table for objective coefficients, modifying existing tables to fill mapping gaps, and updating business configuration logic for scalar parameters and formulas.

CREATE TABLE EffortAllocation (
  poll_source_id INTEGER,
  effort FLOAT
);

CREATE TABLE PollConstraints (
  poll_source_id INTEGER,
  min_effort FLOAT,
  max_effort FLOAT
);

CREATE TABLE PollSupportRates (
  poll_source_id INTEGER,
  support_rate FLOAT
);
```

### Data Dictionary  
The data dictionary provides a comprehensive overview of the tables and columns used in the optimization process, highlighting their business purposes and roles in the optimization model:

- **EffortAllocation**: This table captures the level of effort allocated to each poll source. It plays a crucial role as the decision variable in the optimization model.
  - **poll_source_id**: Serves as the identifier for each poll source, linking effort to specific sources.
  - **effort**: Represents the level of effort allocated to the poll source, acting as the decision variable.

- **PollConstraints**: This table defines the constraints for effort allocation to poll sources, ensuring that allocations remain within feasible limits.
  - **poll_source_id**: Identifies each poll source, linking constraints to specific sources.
  - **min_effort**: Specifies the minimum effort required for each poll source, serving as a lower bound constraint.
  - **max_effort**: Specifies the maximum effort allowed for each poll source, serving as an upper bound constraint.

- **PollSupportRates**: This table stores the support rate coefficient for each poll source, which is used in calculating the total support rate.
  - **poll_source_id**: Identifies each poll source, linking support rates to specific sources.
  - **support_rate**: Represents the support rate coefficient for the poll source, acting as an objective coefficient in the optimization model.

### Current Stored Values  
```sql
-- Iteration 2 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical resource allocation scenarios in political campaigns, ensuring that the support rates and efforts align with realistic campaign strategies.

-- Realistic data for EffortAllocation
INSERT INTO EffortAllocation (poll_source_id, effort) VALUES (1, 15.0);
INSERT INTO EffortAllocation (poll_source_id, effort) VALUES (2, 25.0);
INSERT INTO EffortAllocation (poll_source_id, effort) VALUES (3, 10.0);

-- Realistic data for PollConstraints
INSERT INTO PollConstraints (poll_source_id, min_effort, max_effort) VALUES (1, 5.0, 20.0);
INSERT INTO PollConstraints (poll_source_id, min_effort, max_effort) VALUES (2, 10.0, 30.0);
INSERT INTO PollConstraints (poll_source_id, min_effort, max_effort) VALUES (3, 7.5, 25.0);

-- Realistic data for PollSupportRates
INSERT INTO PollSupportRates (poll_source_id, support_rate) VALUES (1, 0.55);
INSERT INTO PollSupportRates (poll_source_id, support_rate) VALUES (2, 0.75);
INSERT INTO PollSupportRates (poll_source_id, support_rate) VALUES (3, 0.6);
```