# Complete Optimization Problem and Solution: cinema

## 1. Problem Context and Goals

### Context  
The cinema chain is focused on maximizing its revenue by strategically scheduling films across its various locations. Each cinema has a specific capacity and a limited number of show times available per day. The decision-making process involves determining the number of times each film should be shown in each cinema. This decision is represented by integer variables, where each variable corresponds to the number of screenings for a particular film in a specific cinema. The primary objective is to maximize the total revenue generated from these screenings. This is achieved by considering the price per screening for each film in each cinema, which serves as the coefficient in the revenue calculation. The operational parameters include the maximum number of screenings allowed per day for each cinema and the seating capacity, which must not be exceeded. These constraints ensure that the scheduling decisions remain feasible and align with the cinema's operational capabilities.

### Goals  
The primary goal of this optimization problem is to maximize the total revenue from film screenings across all cinemas. The metric for optimization is the total revenue, which is calculated by summing the product of the number of screenings and the price per screening for each film in each cinema. Success in this context is measured by the ability to achieve the highest possible revenue while adhering to the operational constraints of each cinema. The optimization goal is clearly defined in linear terms, focusing on maximizing revenue without involving complex mathematical operations.

## 2. Constraints    

The scheduling decisions are subject to several constraints that ensure the feasibility of the solution:

- Each cinema has a maximum number of screenings it can accommodate per day. The total number of screenings scheduled in a cinema must not exceed this limit.
- The number of attendees for each screening, based on average attendance, must not exceed the seating capacity of the cinema. This ensures that the cinema does not overbook and maintains a comfortable viewing experience for patrons.

These constraints are expressed in linear terms, focusing on the sum of screenings and the relationship between attendance and capacity, without involving nonlinear operations.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Schema changes include adding a new table for objective coefficients, modifying existing tables to fill mapping gaps, and updating configuration logic for scalar parameters and formulas.

CREATE TABLE cinema (
  Cinema_ID INTEGER,
  Capacity INTEGER,
  Max_Screenings_Per_Day INTEGER
);

CREATE TABLE film_schedule (
  Cinema_ID_Film_ID INTEGER,
  Show_Times INTEGER
);

CREATE TABLE film_pricing (
  Cinema_ID_Film_ID INTEGER,
  Price FLOAT
);


```

### Data Dictionary  
The data dictionary provides a business-oriented view of the tables and columns, highlighting their roles in the optimization process:

- **Cinema Table**: This table contains information about each cinema, including its unique identifier, seating capacity, and the maximum number of screenings allowed per day. These attributes are crucial for defining the constraints related to capacity and scheduling limits.

- **Film Schedule Table**: This table records the number of times each film is shown in each cinema. The entries in this table represent the decision variables in the optimization problem, determining the scheduling strategy for maximizing revenue.

- **Film Pricing Table**: This table provides the pricing information for each film in each cinema. The price per screening serves as the coefficient in the revenue calculation, directly influencing the optimization objective.

### Current Stored Values  
```sql
-- Iteration 2 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical cinema operations, considering average cinema capacities, typical pricing strategies, and realistic scheduling constraints.

-- Realistic data for cinema
INSERT INTO cinema (Cinema_ID, Capacity, Max_Screenings_Per_Day) VALUES (1, 120, 5);
INSERT INTO cinema (Cinema_ID, Capacity, Max_Screenings_Per_Day) VALUES (2, 180, 6);
INSERT INTO cinema (Cinema_ID, Capacity, Max_Screenings_Per_Day) VALUES (3, 250, 7);

-- Realistic data for film_schedule
INSERT INTO film_schedule (Cinema_ID_Film_ID, Show_Times) VALUES (101, 3);
INSERT INTO film_schedule (Cinema_ID_Film_ID, Show_Times) VALUES (102, 4);
INSERT INTO film_schedule (Cinema_ID_Film_ID, Show_Times) VALUES (103, 2);

-- Realistic data for film_pricing
INSERT INTO film_pricing (Cinema_ID_Film_ID, Price) VALUES (101, 12.0);
INSERT INTO film_pricing (Cinema_ID_Film_ID, Price) VALUES (102, 15.0);
INSERT INTO film_pricing (Cinema_ID_Film_ID, Price) VALUES (103, 10.0);


```