# Complete Optimization Problem and Solution: county_public_safety

## 1. Problem Context and Goals

### Context  
The objective is to optimize the allocation of police officers across various counties to effectively minimize the overall crime rate. This involves making strategic decisions about the number of police officers assigned to each county. The decision variable in this context is the number of police officers allocated to each county, which is represented as an integer value. The operational parameters are aligned with the goal of minimizing the total crime rate, which is calculated by considering the crime rate in each county and the number of officers assigned there.

The business configuration includes several key parameters: the total number of police officers available for allocation, which serves as a constraint to ensure that the total number of officers assigned does not exceed this limit; the minimum number of officers required in each county, which ensures a baseline level of police presence; and the maximum case burden that can be handled by a single officer, which prevents overloading officers with too many cases. These parameters are crucial for maintaining operational efficiency and ensuring public safety.

The data presented reflects current operational information, focusing on precise decision-making that leads to linear formulations. The constraints are designed to match expected linear relationships, avoiding any scenarios that would require nonlinear relationships such as variable products or divisions. The business configuration parameters are referenced appropriately to ensure a clear understanding of the optimization problem.

### Goals  
The primary goal of this optimization problem is to minimize the total crime rate across all counties. This is achieved by strategically allocating police officers to each county in a way that reduces the overall crime rate. The metric used to measure success is the total crime rate, which is minimized by considering the crime rate in each county and the number of officers assigned there. The optimization goal is clearly defined in natural language, focusing on the linear relationship between the crime rate and the allocation of police officers.

## 2. Constraints    

The optimization problem is subject to several constraints that ensure the solution is feasible and practical:

- The total number of police officers allocated across all counties must not exceed the total number of officers available. This constraint ensures that the allocation does not surpass the resources available.
- Each county must have at least a minimum number of officers assigned to it. This constraint guarantees a baseline level of police presence in every county to maintain public safety.
- The case burden per officer must not exceed the maximum allowed. This constraint prevents any single officer from being overloaded with too many cases, ensuring effective case management and officer well-being.

These constraints are described in business terms that naturally lead to linear mathematical forms, ensuring that the optimization problem remains linear and manageable.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema adjustments and configuration logic updates were made to address missing optimization requirements and improve mapping adequacy based on OR expert analysis.

CREATE TABLE county_public_safety (
  Crime_rate FLOAT,
  Population INTEGER,
  Residents_per_officer INTEGER,
  Case_burden FLOAT,
  Police_officers INTEGER
);
```

### Data Dictionary  
The `county_public_safety` table is designed to store data related to public safety optimization across counties. Each column serves a specific purpose in the optimization process:

- **Crime_rate**: Represents the crime rate in each county. It is used to weigh the impact of police officers on crime reduction.
- **Population**: Indicates the population of each county. This data helps determine the maximum number of officers based on the number of residents per officer.
- **Residents_per_officer**: Shows the number of residents per officer in each county. It is used to limit the number of officers allocated.
- **Case_burden**: Reflects the case burden in each county. This ensures that officers are not overloaded with too many cases.
- **Police_officers**: Represents the number of police officers allocated to each county. This is the decision variable for the optimization process.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were generated based on typical crime rates, population sizes, and police allocation strategies observed in medium-sized counties. The approach ensures that the data reflects realistic scenarios for public safety optimization.

-- Realistic data for county_public_safety
INSERT INTO county_public_safety (Crime_rate, Population, Residents_per_officer, Case_burden, Police_officers) VALUES (0.15, 1500, 150, 7.0, 10);
INSERT INTO county_public_safety (Crime_rate, Population, Residents_per_officer, Case_burden, Police_officers) VALUES (0.25, 2500, 125, 12.0, 20);
INSERT INTO county_public_safety (Crime_rate, Population, Residents_per_officer, Case_burden, Police_officers) VALUES (0.18, 1800, 180, 9.0, 12);
INSERT INTO county_public_safety (Crime_rate, Population, Residents_per_officer, Case_burden, Police_officers) VALUES (0.22, 2200, 110, 11.0, 18);
INSERT INTO county_public_safety (Crime_rate, Population, Residents_per_officer, Case_burden, Police_officers) VALUES (0.2, 2000, 100, 10.0, 15);
```