# Complete Optimization Problem and Solution: course_teach

## 1. Problem Context and Goals

### Context  
The university is focused on enhancing student performance by strategically assigning teachers to courses. Each teacher's assignment to a course is a critical decision, represented by a binary choice indicating whether a teacher is assigned to a specific course. The primary aim is to maximize the overall expected improvement in student grades across all courses. This improvement is calculated based on each teacher's unique expertise and experience, which contributes differently to student outcomes. The operational framework includes a constraint that limits the number of teachers assigned to each course to one, ensuring consistency in teaching style and content delivery. The expected grade improvement is determined by a formula that considers factors such as the teacher's experience and expertise. This setup ensures that the decision-making process is linear, focusing on optimizing the allocation of teaching resources to achieve the best possible educational outcomes.

### Goals  
The optimization goal is to maximize the total expected improvement in student grades by effectively assigning teachers to courses. The metric for optimization is the sum of the expected grade improvements for each teacher-course assignment. Success is measured by the extent to which the assignments enhance overall student performance, aligning with the expected contributions of each teacher as determined by their expertise and experience. The objective is clearly defined in linear terms, focusing on maximizing the cumulative impact of teacher assignments on student grades.

## 2. Constraints    

The assignment of teachers to courses is subject to specific constraints to ensure optimal resource allocation:

- Each course can have at most one teacher assigned to it. This constraint ensures that the teaching style and content delivery remain consistent, aligning with the university's educational standards.
- Each teacher can only be assigned to one course at a time. This constraint ensures that teachers can focus their efforts and expertise on a single course, maximizing their impact on student performance.

These constraints are designed to naturally lead to linear mathematical formulations, ensuring that the optimization process remains straightforward and effective.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for decision variables and constraint bounds, modifying existing tables to improve mapping adequacy, and updating business configuration logic for scalar parameters and formulas.

CREATE TABLE teacher_course_assignment (
  Course_ID INTEGER,
  Teacher_ID INTEGER,
  assignment BOOLEAN
);

CREATE TABLE grade_improvement (
  Course_ID INTEGER,
  Teacher_ID INTEGER,
  expected_improvement FLOAT
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and optimization roles:

- **Teacher Course Assignment Table**: This table tracks the assignment of teachers to courses. It includes:
  - **Course_ID**: A unique identifier for each course, used to identify courses in decision variables.
  - **Teacher_ID**: A unique identifier for each teacher, used to identify teachers in decision variables.
  - **Assignment**: A binary indicator showing whether a teacher is assigned to a course, serving as a decision variable in the optimization process.

- **Grade Improvement Table**: This table stores the expected grade improvement for each teacher-course pair. It includes:
  - **Course_ID**: A unique identifier for each course, used to identify courses in objective coefficients.
  - **Teacher_ID**: A unique identifier for each teacher, used to identify teachers in objective coefficients.
  - **Expected Improvement**: The anticipated grade improvement resulting from a teacher's assignment to a course, acting as a coefficient in the objective function.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical university settings where teachers have varying impacts on student performance, and courses require specific expertise.

-- Realistic data for teacher_course_assignment
INSERT INTO teacher_course_assignment (Course_ID, Teacher_ID, assignment) VALUES (101, 201, True);
INSERT INTO teacher_course_assignment (Course_ID, Teacher_ID, assignment) VALUES (102, 202, True);
INSERT INTO teacher_course_assignment (Course_ID, Teacher_ID, assignment) VALUES (103, 203, True);

-- Realistic data for grade_improvement
INSERT INTO grade_improvement (Course_ID, Teacher_ID, expected_improvement) VALUES (101, 201, 0.8);
INSERT INTO grade_improvement (Course_ID, Teacher_ID, expected_improvement) VALUES (102, 202, 0.6);
INSERT INTO grade_improvement (Course_ID, Teacher_ID, expected_improvement) VALUES (103, 203, 0.7);
INSERT INTO grade_improvement (Course_ID, Teacher_ID, expected_improvement) VALUES (101, 202, 0.5);
INSERT INTO grade_improvement (Course_ID, Teacher_ID, expected_improvement) VALUES (102, 203, 0.4);
```