# Complete Optimization Problem and Solution: culture_company

## 1. Problem Context and Goals

### Context  
The culture company is focused on strategically investing in book clubs and movies to enhance its cultural impact. The decision-making process involves determining the optimal investment amounts for each book club and movie. These investments are represented by continuous variables: x for book clubs and y for movies. The primary objective is to maximize the cultural impact, which is calculated as a weighted sum of the equity shareholding in each book club and movie. The company must operate within a defined budget, which serves as a constraint on the total investment. The business configuration includes a total budget available for investment, which acts as a constraint bound in the optimization model, and the investment cost for each book club, which is used in constraint calculations. The company aims to make precise operational decisions that align with linear formulations, ensuring that resource limitations are addressed through expected linear constraints. The business configuration parameters, such as the total budget and investment costs, are integral to this process.

### Goals  
The primary goal of the optimization is to maximize the cultural impact of the company's investments. This is achieved by optimizing the total cultural impact, which is the sum of the contributions from the equity shareholding in each book club and movie. The success of this optimization is measured by the alignment with expected coefficient sources, ensuring that the cultural impact is maximized through strategic investment decisions. The optimization goal is clearly defined in natural language, focusing on maximizing the cultural impact without the use of mathematical formulas or symbolic notation.

## 2. Constraints    

The company must adhere to a budget constraint that limits the total investment in book clubs and movies. The expected constraint is that the sum of the investment cost per book club multiplied by the investment decision for book clubs, plus the investment decision for movies, must not exceed the total budget. This constraint is expressed in business terms that naturally lead to linear mathematical forms, avoiding any nonlinear relationships such as variable products or divisions.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for decision variables and constraint bounds, modifying existing tables to include missing data, and updating business configuration logic for scalar parameters and formulas.

CREATE TABLE Group_Equity_Shareholding (
  book_club_id INTEGER,
  movie_id INTEGER,
  equity_shareholding FLOAT
);

CREATE TABLE Decision_Variables (
  x FLOAT,
  y FLOAT
);

CREATE TABLE Constraint_Bounds (
  budget_constraint FLOAT
);
```

### Data Dictionary  
The data dictionary provides a comprehensive business-oriented mapping of tables and columns to their purposes and roles in the optimization process:

- **Group_Equity_Shareholding**: This table stores the cultural impact scores for book clubs and movies. It plays a crucial role in the optimization as it provides the coefficients for the objective function. The columns include:
  - **book_club_id**: An identifier for each book club, used to map equity shareholding to book clubs.
  - **movie_id**: An identifier for each movie, used to map equity shareholding to movies.
  - **equity_shareholding**: Represents the contribution to the cultural impact score, serving as a coefficient in the objective function.

- **Decision_Variables**: This table captures the investment decisions for optimization. It includes:
  - **x**: Represents the investment decision in book clubs, serving as a decision variable.
  - **y**: Represents the investment decision in movies, serving as a decision variable.

- **Constraint_Bounds**: This table contains the budget constraints for optimization. It includes:
  - **budget_constraint**: Represents the total budget constraint for investments, acting as a constraint bound in the optimization model.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical investment sizes for cultural projects and realistic equity shareholdings that reflect varying levels of cultural impact.

-- Realistic data for Group_Equity_Shareholding
INSERT INTO Group_Equity_Shareholding (book_club_id, movie_id, equity_shareholding) VALUES (1, None, 0.6);
INSERT INTO Group_Equity_Shareholding (book_club_id, movie_id, equity_shareholding) VALUES (2, None, 0.8);
INSERT INTO Group_Equity_Shareholding (book_club_id, movie_id, equity_shareholding) VALUES (3, None, 0.5);
INSERT INTO Group_Equity_Shareholding (book_club_id, movie_id, equity_shareholding) VALUES (None, 1, 0.7);
INSERT INTO Group_Equity_Shareholding (book_club_id, movie_id, equity_shareholding) VALUES (None, 2, 0.9);
INSERT INTO Group_Equity_Shareholding (book_club_id, movie_id, equity_shareholding) VALUES (None, 3, 0.4);

-- Realistic data for Decision_Variables
INSERT INTO Decision_Variables (x, y) VALUES (20000, None);
INSERT INTO Decision_Variables (x, y) VALUES (30000, None);
INSERT INTO Decision_Variables (x, y) VALUES (15000, None);
INSERT INTO Decision_Variables (x, y) VALUES (None, 25000);
INSERT INTO Decision_Variables (x, y) VALUES (None, 35000);
INSERT INTO Decision_Variables (x, y) VALUES (None, 10000);

-- Realistic data for Constraint_Bounds
INSERT INTO Constraint_Bounds (budget_constraint) VALUES (1000000);
```