# Complete Optimization Problem and Solution: customer_complaints

## 1. Problem Context and Goals

### Context  
The business is focused on optimizing the allocation of staff to manage customer complaints effectively. The primary decision involves determining whether a specific complaint is assigned to a staff member, represented by a binary decision variable. The operational objective is to minimize the total time required to resolve all complaints. This is achieved by summing the resolution times for each complaint that is assigned to a staff member. Each staff member has a defined capacity, indicating the maximum number of complaints they can handle, which serves as a constraint in the optimization model. The resolution time for each complaint is calculated based on the difference between the date the complaint was raised and the date it was resolved. This calculation is used to determine the coefficients in the optimization model. The business configuration includes parameters such as the maximum number of complaints a staff member can handle, which is crucial for maintaining workload balance and efficiency. The focus is on precise operational decision-making that aligns with linear optimization formulations, avoiding any nonlinear relationships.

### Goals  
The optimization goal is to minimize the total time taken to resolve all customer complaints. This is achieved by strategically assigning complaints to staff members in a way that reduces the overall resolution time. The success of this optimization is measured by the reduction in total resolution time, which is calculated by summing the resolution times for all assigned complaints. The objective is clearly defined in linear terms, focusing on minimizing the total resolution time without involving any complex mathematical expressions.

## 2. Constraints    

The optimization model includes specific constraints to ensure effective complaint management:

- Each complaint must be assigned to exactly one staff member. This ensures that every complaint is addressed and resolved.
- The number of complaints assigned to each staff member must not exceed their maximum handling capacity. This constraint ensures that no staff member is overloaded, maintaining a balanced workload across the team.

These constraints are expressed in business terms that naturally lead to linear mathematical forms, ensuring clarity and consistency in the optimization process.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating a new table for staff capacity and modifying the Complaints table to include resolution time. Configuration logic updates include adding scalar parameters for staff capacity and a formula for resolution time calculation.

CREATE TABLE Complaints (
  complaint_id INTEGER,
  date_complaint_raised DATE,
  date_complaint_closed DATE,
  resolution_time INTEGER
);

CREATE TABLE StaffCapacity (
  staff_id INTEGER,
  max_complaints INTEGER
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and roles in the optimization process:

- **Complaints Table**: This table stores information about customer complaints. Each complaint is uniquely identified by a complaint ID, which serves as a decision variable in the optimization model. The table includes the date the complaint was raised and resolved, which are used to calculate the resolution time. The resolution time acts as an objective coefficient in the optimization model.

- **StaffCapacity Table**: This table records the maximum number of complaints each staff member can handle. Each staff member is uniquely identified by a staff ID. The maximum complaints column serves as a constraint bound in the optimization model, ensuring that staff capacity is not exceeded.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical business operations for handling customer complaints, considering average resolution times and staff capacity in a medium-sized customer service department.

-- Realistic data for Complaints
INSERT INTO Complaints (complaint_id, date_complaint_raised, date_complaint_closed, resolution_time) VALUES (1, 2023-01-01, 2023-01-03, 2);
INSERT INTO Complaints (complaint_id, date_complaint_raised, date_complaint_closed, resolution_time) VALUES (2, 2023-01-02, 2023-01-05, 3);
INSERT INTO Complaints (complaint_id, date_complaint_raised, date_complaint_closed, resolution_time) VALUES (3, 2023-01-03, 2023-01-06, 3);

-- Realistic data for StaffCapacity
INSERT INTO StaffCapacity (staff_id, max_complaints) VALUES (1, 5);
INSERT INTO StaffCapacity (staff_id, max_complaints) VALUES (2, 7);
INSERT INTO StaffCapacity (staff_id, max_complaints) VALUES (3, 6);
```