# Complete Optimization Problem and Solution: debate

## 1. Problem Context and Goals

### Context  
A political organization is focused on optimizing the allocation of speakers to various debates. The primary decision involves determining whether a speaker should be assigned to a specific debate. This decision is represented by binary variables, where each variable indicates if a speaker is assigned to a debate. The organization aims to maximize the total audience reached by these debates. The operational parameters include the maximum number of debates a speaker can attend and the maximum number of speakers allowed per debate. These parameters are crucial for ensuring that the allocation remains feasible and effective. The business configuration specifies that each speaker can attend up to a certain number of debates, and each debate can host a limited number of speakers. This setup ensures that the optimization problem remains linear, avoiding complex relationships such as variable products or divisions. The data used in this process reflects current operational realities, ensuring that the optimization aligns with actual business constraints and opportunities.

### Goals  
The primary goal of this optimization is to maximize the total number of audience members reached through the strategic assignment of speakers to debates. The metric for optimization is the sum of audience numbers for each debate, weighted by the assignment of speakers to those debates. Success is measured by the extent to which the total audience is maximized, using the number of audience members as the coefficient source. This goal is articulated in natural language to maintain clarity and focus on the linear nature of the optimization objective.

## 2. Constraints    

The optimization process is governed by two main constraints. First, each speaker is limited to participating in a maximum number of debates, ensuring that their availability is not overstretched. This constraint is defined by the maximum number of debates a speaker can attend. Second, each debate can accommodate only a limited number of speakers, which is determined by the maximum number of speakers allowed per debate. These constraints are expressed in business terms that naturally lead to linear mathematical forms, ensuring that the optimization remains straightforward and manageable.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for decision variables and constraint bounds, modifying existing tables to fill mapping gaps, and moving scalar parameters to configuration logic.

CREATE TABLE debate (
  Debate_ID INTEGER,
  Num_of_Audience INTEGER
);

CREATE TABLE decision_variables (
  Debate_ID INTEGER,
  People_ID INTEGER,
  assignment BOOLEAN
);

CREATE TABLE constraint_bounds (
  Constraint_Name STRING,
  Value INTEGER
);
```

### Data Dictionary  
The data dictionary provides a comprehensive overview of the tables and columns used in the optimization process, highlighting their business purposes and roles in the optimization:

- **Debate Table**: This table stores information about each debate, including the number of audience members expected. The audience size serves as a coefficient in the optimization objective, helping to prioritize debates with larger audiences.

  - **Debate_ID**: A unique identifier for each debate, used to index debates in the optimization process.
  - **Num_of_Audience**: Represents the number of audience members for each debate, serving as a key factor in the optimization objective.

- **Decision Variables Table**: This table captures the binary decision variables that indicate whether a speaker is assigned to a debate.

  - **Debate_ID**: Identifies the debate in question, linking the decision variable to a specific debate.
  - **People_ID**: Identifies the speaker, linking the decision variable to a specific individual.
  - **Assignment**: A binary indicator showing whether a speaker is assigned to a debate, forming the core decision variable in the optimization.

- **Constraint Bounds Table**: This table defines the bounds for constraints related to debates and speakers.

  - **Constraint_Name**: Names the constraint, distinguishing between different types of constraints such as speaker participation limits and debate capacity limits.
  - **Value**: Specifies the bound value for each constraint, ensuring that the optimization adheres to business rules and limitations.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were chosen based on typical constraints in political organizations, ensuring a balance between speaker availability and debate audience size.

-- Realistic data for debate
INSERT INTO debate (Debate_ID, Num_of_Audience) VALUES (1, 150);
INSERT INTO debate (Debate_ID, Num_of_Audience) VALUES (2, 250);
INSERT INTO debate (Debate_ID, Num_of_Audience) VALUES (3, 100);

-- Realistic data for decision_variables
INSERT INTO decision_variables (Debate_ID, People_ID, assignment) VALUES (1, 101, True);
INSERT INTO decision_variables (Debate_ID, People_ID, assignment) VALUES (1, 102, False);
INSERT INTO decision_variables (Debate_ID, People_ID, assignment) VALUES (2, 101, True);
INSERT INTO decision_variables (Debate_ID, People_ID, assignment) VALUES (2, 103, True);
INSERT INTO decision_variables (Debate_ID, People_ID, assignment) VALUES (3, 102, True);

-- Realistic data for constraint_bounds
INSERT INTO constraint_bounds (Constraint_Name, Value) VALUES ('Max_Debates_Per_Speaker', 3);
INSERT INTO constraint_bounds (Constraint_Name, Value) VALUES ('Max_Speakers_Per_Debate', 5);
```