# Complete Optimization Problem and Solution: device

## 1. Problem Context and Goals

### Context  
The retail company is focused on optimizing the distribution of its devices across various shops to maximize potential sales. The decision-making process involves determining the number of devices to allocate to each shop, represented by integer variables. The primary objective is to maximize the total sales potential, which is calculated by multiplying the estimated sales potential of each device at each shop by the number of devices allocated. The company must consider the maximum capacity of each shop, which serves as a constraint in the optimization model. The potential sales for each device at each shop are determined using a business logic formula that considers base sales and a demand factor. This approach ensures that the decision-making process is linear, avoiding any nonlinear relationships such as variable products or divisions. The operational parameters, including shop capacity and potential sales, are clearly defined to align with the expected coefficient sources in the optimization model.

### Goals  
The primary goal of the optimization process is to maximize the total potential sales across all shops. This involves strategically allocating devices to shops in a way that maximizes the sum of the estimated sales potential for each device, multiplied by the number of devices allocated. Success is measured by the total sales potential achieved, ensuring that the allocation aligns with the expected coefficient sources. The optimization goal is clearly defined in linear terms, focusing on maximizing the total sales potential without involving any complex mathematical expressions.

## 2. Constraints    

The optimization model is subject to several constraints that ensure the feasibility of the solution:

- The total number of devices allocated to each shop must not exceed the shop's maximum capacity. This constraint ensures that the allocation respects the physical limitations of each shop.
- The number of devices allocated to each shop must be a non-negative integer, reflecting the practical requirement that allocations cannot be negative or fractional.

These constraints are expressed in business terms that naturally lead to linear mathematical forms, ensuring that the optimization problem remains linear and manageable.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for missing optimization data and updating configuration logic for scalar parameters and formulas.

CREATE TABLE PotentialSales (
  shop_id INTEGER,
  device_id INTEGER,
  potential_sales FLOAT
);

CREATE TABLE ShopCapacity (
  shop_id INTEGER,
  capacity INTEGER
);

CREATE TABLE Allocation (
  shop_id INTEGER,
  device_id INTEGER,
  quantity INTEGER
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and optimization roles:

- **PotentialSales Table**: This table estimates the sales potential for each device at each shop. It plays a crucial role in determining the coefficients for the objective function in the optimization model.
  - **shop_id**: Represents the unique identifier for each shop.
  - **device_id**: Represents the unique identifier for each device.
  - **potential_sales**: Indicates the estimated sales potential for a specific device at a specific shop.

- **ShopCapacity Table**: This table defines the maximum number of devices each shop can hold, serving as a constraint in the optimization model.
  - **shop_id**: Represents the unique identifier for each shop.
  - **capacity**: Indicates the maximum capacity of the shop in terms of device allocation.

- **Allocation Table**: This table records the number of devices allocated to each shop, representing the decision variables in the optimization model.
  - **shop_id**: Represents the unique identifier for each shop.
  - **device_id**: Represents the unique identifier for each device.
  - **quantity**: Indicates the number of devices allocated to a specific shop.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical retail scenarios where device allocation is influenced by shop capacity and potential sales. The values ensure a balance between demand and supply, reflecting realistic business operations.

-- Realistic data for PotentialSales
INSERT INTO PotentialSales (shop_id, device_id, potential_sales) VALUES (1, 101, 600.0);
INSERT INTO PotentialSales (shop_id, device_id, potential_sales) VALUES (2, 102, 850.0);
INSERT INTO PotentialSales (shop_id, device_id, potential_sales) VALUES (3, 103, 950.0);

-- Realistic data for ShopCapacity
INSERT INTO ShopCapacity (shop_id, capacity) VALUES (1, 120);
INSERT INTO ShopCapacity (shop_id, capacity) VALUES (2, 180);
INSERT INTO ShopCapacity (shop_id, capacity) VALUES (3, 220);

-- Realistic data for Allocation
INSERT INTO Allocation (shop_id, device_id, quantity) VALUES (1, 101, 30);
INSERT INTO Allocation (shop_id, device_id, quantity) VALUES (2, 102, 50);
INSERT INTO Allocation (shop_id, device_id, quantity) VALUES (3, 103, 70);
```