# Complete Optimization Problem and Solution: entertainment_awards

## 1. Problem Context and Goals

### Context  
The entertainment festival is focused on maximizing the success of artwork nominations across various festivals. Each nomination is a binary decision, indicating whether an artwork is successfully nominated at a specific festival. The primary objective is to prioritize nominations based on the audience size of each festival, thereby maximizing the overall impact and visibility of the artworks. The operational parameters include constraints on the maximum number of nominations allowed per artwork and the maximum number of artworks that can be nominated at each festival. These constraints ensure a balanced distribution of nominations and manageability of the festival events. The business configuration includes specific parameters such as the maximum nominations per artwork, set at a typical limit to balance exposure and exclusivity, and the maximum capacity per festival, reflecting common limits for medium-sized festivals to ensure manageability.

### Goals  
The optimization goal is to maximize the total impact of successful nominations by considering the audience size at each festival. The metric to optimize is the sum of the audience sizes for all successful nominations, which directly correlates to the visibility and reach of the artworks. This goal is achieved by strategically selecting nominations that maximize audience exposure, ensuring that the festival's resources are utilized effectively to promote the most impactful artworks.

## 2. Constraints    

The optimization model is subject to two primary constraints. First, each artwork can only be nominated a limited number of times, as specified by the maximum nominations allowed per artwork. This constraint ensures that no single artwork dominates the nomination process, allowing for a diverse range of artworks to be showcased. Second, each festival has a maximum capacity for nominations, which limits the number of artworks that can be nominated at any given festival. This constraint ensures that the festival remains manageable and that the audience can fully engage with each nominated artwork. These constraints are linear in nature, aligning with the operational parameters and ensuring a straightforward optimization process.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for missing constraint bounds, modifying existing tables to improve mapping adequacy, and updating business configuration logic for scalar parameters and formulas.

CREATE TABLE festival_detail (
  Num_of_Audience INTEGER
);

CREATE TABLE nomination (
  Result BOOLEAN
);

CREATE TABLE artwork_constraints (
  max_nominations INTEGER
);

CREATE TABLE festival_constraints (
  max_capacity INTEGER
);
```

### Data Dictionary  
The data dictionary provides a comprehensive overview of the tables and columns used in the optimization model, highlighting their business purposes and roles in the optimization process:

- **Festival Detail**: This table stores information about each festival, specifically the number of audience members, which serves as a weight in the optimization objective to prioritize nominations based on audience size.

- **Nomination**: This table records the results of artwork nominations at festivals. The result is a binary indicator of whether an artwork is successfully nominated, serving as the decision variable in the optimization model.

- **Artwork Constraints**: This table defines the constraints related to artworks, specifically the maximum number of nominations allowed per artwork. This constraint ensures a balanced representation of artworks across festivals.

- **Festival Constraints**: This table outlines the constraints related to festivals, specifically the maximum capacity of nominations per festival. This constraint ensures that each festival remains manageable and that the audience can engage with the nominated artworks.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical festival sizes and artwork nomination limits to ensure a balanced and realistic scenario for optimization.

-- Realistic data for festival_detail
INSERT INTO festival_detail (Num_of_Audience) VALUES (1200);
INSERT INTO festival_detail (Num_of_Audience) VALUES (4500);
INSERT INTO festival_detail (Num_of_Audience) VALUES (9000);

-- Realistic data for nomination
INSERT INTO nomination (Result) VALUES (0);
INSERT INTO nomination (Result) VALUES (1);
INSERT INTO nomination (Result) VALUES (0);
INSERT INTO nomination (Result) VALUES (1);
INSERT INTO nomination (Result) VALUES (0);

-- Realistic data for artwork_constraints
INSERT INTO artwork_constraints (max_nominations) VALUES (3);
INSERT INTO artwork_constraints (max_nominations) VALUES (5);
INSERT INTO artwork_constraints (max_nominations) VALUES (7);

-- Realistic data for festival_constraints
INSERT INTO festival_constraints (max_capacity) VALUES (50);
INSERT INTO festival_constraints (max_capacity) VALUES (100);
INSERT INTO festival_constraints (max_capacity) VALUES (150);
```