# Complete Optimization Problem and Solution: flight_4

## 1. Problem Context and Goals

### Context  
The airline is focused on optimizing the allocation of its flights across various routes to maximize the total number of passengers transported. Each route has a specific passenger capacity, and the airline aims to ensure that all routes are serviced by at least one flight. The decision variable in this context is the number of flights assigned to each route, which is an integer value. The operational parameters include the total number of flights available for allocation and the maximum number of flights that can be assigned to each route. These parameters are used as constraints in the optimization model. The airline's business configuration specifies that there are a total of 12 flights available for allocation, and no more than 5 flights can be assigned to any single route. This setup ensures that the optimization problem remains linear, focusing on maximizing passenger transport without involving nonlinear relationships.

### Goals  
The primary goal of the optimization is to maximize the total number of passengers transported across all routes. This is achieved by strategically assigning flights to routes based on their passenger capacities. The success of this optimization is measured by the total number of passengers, which is calculated by summing the product of the passenger capacity of each route and the number of flights assigned to that route. The objective is clearly defined in linear terms, focusing on maximizing passenger transport while adhering to the constraints of flight availability and route capacity.

## 2. Constraints    

The optimization problem is subject to several constraints that ensure the solution is feasible and aligns with business requirements:

- The total number of flights assigned across all routes must not exceed the total number of flights available, which is 12.
- Each route can have a maximum of 5 flights assigned to it, ensuring that no single route is over-serviced.
- Every route must have at least one flight assigned to ensure that all routes are operational.

These constraints are expressed in business terms that naturally lead to linear mathematical forms, avoiding any nonlinear relationships such as variable products or divisions.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for missing optimization data and updating configuration logic for scalar parameters and formulas.

CREATE TABLE routes (
  route_id INTEGER,
  passenger_capacity INTEGER
);

CREATE TABLE flights (
  route_id INTEGER,
  number_of_flights INTEGER
);
```

### Data Dictionary  
The data dictionary provides a business-oriented mapping of tables and columns to their purposes and roles in the optimization process:

- **Routes Table**: This table stores data specific to each route, including the passenger capacity. The passenger capacity serves as a coefficient in the objective function, representing the potential number of passengers that can be transported on each route.
  - **route_id**: A unique identifier for each route, used to link route data.
  - **passenger_capacity**: The maximum number of passengers that can be accommodated on the route, used as a coefficient in the optimization objective.

- **Flights Table**: This table records the number of flights assigned to each route, which is the primary decision variable in the optimization model.
  - **route_id**: An identifier linking to the route, ensuring that flight assignments are correctly associated with their respective routes.
  - **number_of_flights**: The number of flights assigned to the route, serving as the decision variable in the optimization process.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical airline operations, ensuring that the number of flights and passenger capacities are realistic for a mid-sized airline.

-- Realistic data for routes
INSERT INTO routes (route_id, passenger_capacity) VALUES (1, 150);
INSERT INTO routes (route_id, passenger_capacity) VALUES (2, 200);
INSERT INTO routes (route_id, passenger_capacity) VALUES (3, 250);

-- Realistic data for flights
INSERT INTO flights (route_id, number_of_flights) VALUES (1, 3);
INSERT INTO flights (route_id, number_of_flights) VALUES (2, 4);
INSERT INTO flights (route_id, number_of_flights) VALUES (3, 5);
```