# Complete Optimization Problem and Solution: gas_company

## 1. Problem Context and Goals

### Context  
The gas company is focused on optimizing the allocation of its gas stations to various companies. The primary decision involves determining whether a company should be allocated a gas station, represented by a binary decision variable. The objective is to maximize the overall market value derived from these allocations. This decision-making process is guided by several operational parameters, including an upper limit on total sales, a minimum required total profit, and an upper limit on total assets for the companies involved. These parameters are crucial as they serve as constraints in the optimization model, ensuring that the allocations are feasible and align with the company's strategic goals. The business configuration includes these scalar parameters, which are set to reflect realistic operational limits and ensure financial stability. The approach is linear, focusing on straightforward relationships without involving complex interactions like variable products or divisions.

### Goals  
The optimization goal is to maximize the total market value of the companies that are allocated gas stations. This is achieved by focusing on the sum of the market values of the companies that receive allocations. Success is measured by how well the allocation maximizes this sum, ensuring that the decision variables align with the expected coefficient sources. The goal is articulated in natural language, emphasizing the linear nature of the optimization objective without resorting to mathematical notation.

## 2. Constraints    

The optimization problem is subject to several constraints that ensure the allocations are practical and align with business objectives:

- The total sales generated by the allocated companies must not exceed a specified upper limit. This constraint ensures that the company's market reach is balanced with its operational capacity.
- The total profits from the allocated companies must meet or exceed a minimum requirement. This ensures that the allocations contribute positively to the company's bottom line.
- The total assets of the allocated companies must remain within an upper limit. This constraint prevents companies from overextending their asset base, promoting financial stability.

These constraints are described in business terms that naturally lead to linear mathematical forms, avoiding complex interactions like variable products or divisions.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for constraint bounds and modifying existing tables to fill mapping gaps. Configuration logic updated for scalar parameters and formulas.

CREATE TABLE company (
  Company_ID INTEGER,
  Market_Value FLOAT
);

CREATE TABLE station_company (
  Station_ID INTEGER,
  Company_ID INTEGER
);

CREATE TABLE constraint_bounds (
  Constraint_Name STRING,
  Bound_Value FLOAT
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and optimization roles:

- **Company Table**: This table stores information about each company, including a unique identifier and its market value. The market value serves as a coefficient in the objective function, linking the company's potential contribution to the optimization goal.

- **Station_Company Table**: This table links gas stations to companies, with each entry indicating which company manages a particular station. The company identifier in this table is used as a binary decision variable, determining whether a company is allocated a gas station.

- **Constraint_Bounds Table**: This table stores the bounds for various optimization constraints. Each entry includes the name of the constraint and its corresponding bound value, which are used to formulate the constraints in the optimization model.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical market values, sales, profits, and asset distributions for medium-sized gas companies. The approach ensures that the constraints are neither too tight nor too loose, allowing for a meaningful optimization problem.

-- Realistic data for company
INSERT INTO company (Company_ID, Market_Value) VALUES (1, 12.5);
INSERT INTO company (Company_ID, Market_Value) VALUES (2, 18.0);
INSERT INTO company (Company_ID, Market_Value) VALUES (3, 14.0);

-- Realistic data for station_company
INSERT INTO station_company (Station_ID, Company_ID) VALUES (101, 1);
INSERT INTO station_company (Station_ID, Company_ID) VALUES (102, 2);
INSERT INTO station_company (Station_ID, Company_ID) VALUES (103, 3);
INSERT INTO station_company (Station_ID, Company_ID) VALUES (104, 1);
INSERT INTO station_company (Station_ID, Company_ID) VALUES (105, 2);

-- Realistic data for constraint_bounds
INSERT INTO constraint_bounds (Constraint_Name, Bound_Value) VALUES ('Total_Sales_Limit', 120.0);
INSERT INTO constraint_bounds (Constraint_Name, Bound_Value) VALUES ('Minimum_Profits_Requirement', 60.0);
INSERT INTO constraint_bounds (Constraint_Name, Bound_Value) VALUES ('Total_Assets_Limit', 250.0);
```