# Complete Optimization Problem and Solution: inn_1

## 1. Problem Context and Goals

### Context  
The inn is focused on maximizing its revenue by strategically setting room rates while ensuring that room occupancy does not exceed the established capacity and all reservations are fulfilled. The primary decision variable in this optimization is the rate charged for each reservation, which is directly linked to the reservation details stored in the system. The operational objective is to maximize the total revenue, calculated as the sum of the product of the rate charged for each reservation and the length of stay for that reservation. 

The business configuration includes key parameters such as the maximum number of people that can occupy a room, which serves as a constraint to ensure that room capacity is not exceeded. Additionally, there is a minimum rate that can be charged for a room, ensuring that the inn remains competitive while covering basic costs. The length of stay for each reservation is calculated based on the check-in and check-out dates, and this information is used in the revenue calculation. 

The data presented reflects current operational information, focusing on precise decision-making that aligns with linear optimization formulations. The constraints are designed to match expected linear relationships, avoiding any scenarios that would require nonlinear calculations. Specific operational parameters are clearly mapped to their respective coefficient sources, ensuring consistency and clarity in the optimization model.

### Goals  
The primary goal of this optimization problem is to maximize the total revenue generated from room bookings. This is achieved by adjusting the room rates while adhering to the constraints of room occupancy and minimum pricing. The success of this optimization is measured by the total revenue, which is calculated as the sum of the rate charged for each reservation multiplied by the length of stay for that reservation. The optimization goal is clearly defined in natural language, focusing on maximizing revenue through linear relationships without the use of mathematical formulas or symbolic notation.

## 2. Constraints    

The optimization model includes constraints that ensure the business operates within its defined parameters. One key constraint is the maximum occupancy for each room, which ensures that the number of people occupying a room does not exceed its capacity. This constraint is directly linked to the business configuration logic and is crucial for maintaining operational efficiency and customer satisfaction.

Another important constraint is the base price for each reservation, which ensures that the rate charged does not fall below a specified minimum. This constraint is essential for maintaining profitability and competitiveness in the market. Both constraints are described in business terms that naturally lead to linear mathematical forms, avoiding any nonlinear relationships such as variable products or divisions.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include adding a new table for reservation durations and modifying existing tables to ensure all reservations are mapped to rooms. Configuration logic updated for scalar parameters and formulas.

CREATE TABLE Reservations (
  ReservationId INTEGER,
  Rate FLOAT,
  RoomId INTEGER
);

CREATE TABLE ReservationDurations (
  ReservationId INTEGER,
  LengthOfStay INTEGER
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and optimization roles. 

- **Reservations Table**: This table stores details about each reservation, including the rate charged and the room assigned. The primary role of this table in the optimization model is to define the decision variables, specifically the rate charged for each reservation. The columns include:
  - **ReservationId**: A unique identifier for each reservation, used to link reservation details in the optimization model.
  - **Rate**: The rate charged for the reservation, serving as a decision variable for revenue maximization.
  - **RoomId**: An identifier for the room assigned to the reservation, ensuring that each reservation is mapped to a room.

- **ReservationDurations Table**: This table records the length of stay for each reservation, which is crucial for calculating revenue. The columns include:
  - **ReservationId**: A unique identifier for each reservation, linking the duration to the reservation.
  - **LengthOfStay**: The number of days for the reservation, used in the revenue calculation.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical room rates and occupancy patterns in a mid-range inn, ensuring that the rates are competitive yet profitable, and that the length of stay reflects common booking durations.

-- Realistic data for Reservations
INSERT INTO Reservations (ReservationId, Rate, RoomId) VALUES (1, 120.0, 101);
INSERT INTO Reservations (ReservationId, Rate, RoomId) VALUES (2, 150.0, 102);
INSERT INTO Reservations (ReservationId, Rate, RoomId) VALUES (3, 200.0, 103);

-- Realistic data for ReservationDurations
INSERT INTO ReservationDurations (ReservationId, LengthOfStay) VALUES (1, 2);
INSERT INTO ReservationDurations (ReservationId, LengthOfStay) VALUES (2, 3);
INSERT INTO ReservationDurations (ReservationId, LengthOfStay) VALUES (3, 5);
```