# Complete Optimization Problem and Solution: journal_committee

## 1. Problem Context and Goals

### Context  
The publishing company is focused on optimizing the allocation of editors to journals to enhance overall sales performance. The decision-making process involves determining whether an editor is assigned to a specific journal, represented by binary decision variables. The primary operational goal is to maximize the total sales of journals by strategically assigning editors, while adhering to workload limitations and ensuring editors are only assigned to journals within their area of expertise. The business configuration includes a critical parameter: the maximum number of journals an editor can manage, which serves as a constraint to prevent overburdening editors. This setup ensures that the optimization problem remains linear, avoiding complex relationships such as variable products or divisions. The data used in this process reflects current operational realities, providing a realistic basis for decision-making.

### Goals  
The optimization goal is to maximize the total sales generated by the journals. This is achieved by assigning editors to journals in a manner that maximizes the sum of sales associated with each journal assignment. The success of this optimization is measured by the total sales figure, which is directly influenced by the assignment decisions. The objective is clearly defined in linear terms, focusing on maximizing the sum of sales contributions from each journal-editor assignment.

## 2. Constraints    

The optimization process is subject to several constraints to ensure feasibility and alignment with business requirements:

- Each editor can be assigned to a limited number of journals, specifically up to the maximum number of journals they can handle. This constraint ensures that editors are not overburdened and can maintain quality in their work.
  
- Editors can only be assigned to journals for which they are qualified based on the journal's theme. This constraint ensures that editors are matched with journals that align with their expertise, maintaining the quality and relevance of editorial work.

These constraints are expressed in a manner that naturally leads to linear mathematical formulations, avoiding any nonlinear relationships.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 2 Database Schema
-- Objective: Incorporated Sales_journal data into the schema for objective coefficient mapping and updated business configuration logic for scalar parameters.

CREATE TABLE journal_committee (
  Editor_ID INTEGER,
  Journal_ID INTEGER
);

CREATE TABLE editor_qualifications (
  Editor_ID INTEGER,
  Theme STRING
);

CREATE TABLE journal_sales (
  Journal_ID INTEGER,
  Sales FLOAT
);
```

### Data Dictionary  
The data dictionary provides a comprehensive overview of the tables and columns, detailing their business purposes and roles in the optimization process:

- **Journal Committee Table**: This table records the assignments of editors to journals. It plays a crucial role in defining the decision variables for the optimization problem, where each entry indicates a potential assignment.

  - **Editor_ID**: Serves as a unique identifier for each editor, crucial for tracking assignments.
  - **Journal_ID**: Serves as a unique identifier for each journal, essential for mapping assignments.

- **Editor Qualifications Table**: This table captures the themes for which each editor is qualified, ensuring that assignments are made within the editor's area of expertise.

  - **Editor_ID**: Identifies each editor, linking them to their qualifications.
  - **Theme**: Represents the specific theme an editor is qualified to handle, used to enforce qualification constraints.

- **Journal Sales Table**: This table contains sales data for each journal, which is used as coefficients in the objective function to maximize total sales.

  - **Journal_ID**: Identifies each journal, linking it to its sales data.
  - **Sales**: Represents the sales figures associated with each journal, serving as a key component in the optimization objective.

### Current Stored Values  
```sql
-- Iteration 2 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical workload capacities for editors and realistic sales figures for journals in a mid-sized publishing company.

-- Realistic data for journal_committee
INSERT INTO journal_committee (Editor_ID, Journal_ID) VALUES (1, 101);
INSERT INTO journal_committee (Editor_ID, Journal_ID) VALUES (2, 102);
INSERT INTO journal_committee (Editor_ID, Journal_ID) VALUES (3, 103);

-- Realistic data for editor_qualifications
INSERT INTO editor_qualifications (Editor_ID, Theme) VALUES (1, 'Science');
INSERT INTO editor_qualifications (Editor_ID, Theme) VALUES (2, 'Arts');
INSERT INTO editor_qualifications (Editor_ID, Theme) VALUES (3, 'Technology');

-- Realistic data for journal_sales
INSERT INTO journal_sales (Journal_ID, Sales) VALUES (101, 1200.0);
INSERT INTO journal_sales (Journal_ID, Sales) VALUES (102, 1800.0);
INSERT INTO journal_sales (Journal_ID, Sales) VALUES (103, 1600.0);
```