# Complete Optimization Problem and Solution: local_govt_in_alabama

## 1. Problem Context and Goals

### Context  
The local government in Alabama is organizing a series of community events and aims to optimize the allocation of participants to these events. The primary objective is to maximize the overall satisfaction score derived from participants attending specific events. Each participant has a predefined satisfaction score for attending each event, which reflects their preference or interest level. The decision to assign a participant to an event is represented by a binary choice, indicating whether a participant is assigned to a particular event or not. 

Operationally, the goal is to maximize the total satisfaction score by making these assignments while adhering to the capacity constraints of each event. The capacity constraint is defined by the maximum number of participants that can be accommodated at each event, ensuring that no event exceeds its designated capacity. This constraint is a critical parameter in the optimization model, reflecting the logistical and resource limitations of event management. The business configuration includes these capacity limits, which are scalar parameters determined by typical event sizes and logistical considerations.

### Goals  
The optimization goal is to maximize the total satisfaction score across all events. This involves strategically assigning participants to events in a manner that maximizes the sum of their satisfaction scores. The success of this optimization is measured by the total satisfaction score achieved, which is directly influenced by the satisfaction scores of participants for their assigned events. The objective is to ensure that the assignments lead to the highest possible aggregate satisfaction, reflecting the preferences and interests of the participants while respecting the capacity constraints of each event.

## 2. Constraints    

The optimization problem is subject to several constraints that ensure feasibility and adherence to business rules:

- Each event has a maximum capacity, which limits the number of participants that can be assigned to it. This constraint ensures that the total number of participants assigned to any event does not exceed its capacity limit.
- The assignment of participants to events is binary, meaning a participant can either be assigned to an event or not. This constraint ensures that each participant-event assignment is a clear yes or no decision, reflecting the binary nature of the decision variables.

These constraints are designed to align with the linear mathematical formulation of the problem, ensuring that the optimization process respects the logistical and operational limitations of event management.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for satisfaction scores and event capacities, modifying existing tables to improve mapping adequacy, and updating business configuration logic for scalar parameters and formulas.

CREATE TABLE SatisfactionScores (
  participant_id INTEGER,
  event_id INTEGER,
  satisfaction_score FLOAT
);

CREATE TABLE EventCapacities (
  event_id INTEGER,
  capacity_limit INTEGER
);

CREATE TABLE Participants_in_Events (
  participant_id INTEGER,
  event_id INTEGER,
  participant_event_assignment BOOLEAN
);
```

### Data Dictionary  
The data used in this optimization problem is structured to support the decision-making process:

- **SatisfactionScores**: This table captures the satisfaction scores for each participant-event pair. It serves as the source of coefficients for the objective function, representing the level of satisfaction a participant derives from attending a specific event.
  - **participant_id**: A unique identifier for each participant, used to index satisfaction scores.
  - **event_id**: A unique identifier for each event, used to index satisfaction scores.
  - **satisfaction_score**: The satisfaction score of a participant attending an event, serving as a coefficient in the objective function.

- **EventCapacities**: This table stores the capacity limits for each event, which are used as bounds in the optimization model.
  - **event_id**: A unique identifier for each event, used to index capacity constraints.
  - **capacity_limit**: The maximum number of participants allowed for the event, serving as a constraint bound.

- **Participants_in_Events**: This table tracks the assignments of participants to events, representing the decision variables in the optimization model.
  - **participant_id**: A unique identifier for each participant, used to index decision variables.
  - **event_id**: A unique identifier for each event, used to index decision variables.
  - **participant_event_assignment**: A binary indicator of whether a participant is assigned to an event, representing the decision variable.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical event sizes and participant preferences in community events, ensuring a diverse range of satisfaction scores and capacity limits to reflect realistic scenarios.

-- Realistic data for SatisfactionScores
INSERT INTO SatisfactionScores (participant_id, event_id, satisfaction_score) VALUES (1, 101, 0.7);
INSERT INTO SatisfactionScores (participant_id, event_id, satisfaction_score) VALUES (1, 102, 0.9);
INSERT INTO SatisfactionScores (participant_id, event_id, satisfaction_score) VALUES (2, 101, 0.6);
INSERT INTO SatisfactionScores (participant_id, event_id, satisfaction_score) VALUES (2, 103, 0.8);
INSERT INTO SatisfactionScores (participant_id, event_id, satisfaction_score) VALUES (3, 102, 0.5);

-- Realistic data for EventCapacities
INSERT INTO EventCapacities (event_id, capacity_limit) VALUES (101, 50);
INSERT INTO EventCapacities (event_id, capacity_limit) VALUES (102, 100);
INSERT INTO EventCapacities (event_id, capacity_limit) VALUES (103, 150);

-- Realistic data for Participants_in_Events
INSERT INTO Participants_in_Events (participant_id, event_id, participant_event_assignment) VALUES (1, 101, True);
INSERT INTO Participants_in_Events (participant_id, event_id, participant_event_assignment) VALUES (1, 102, False);
INSERT INTO Participants_in_Events (participant_id, event_id, participant_event_assignment) VALUES (2, 101, True);
INSERT INTO Participants_in_Events (participant_id, event_id, participant_event_assignment) VALUES (2, 103, True);
INSERT INTO Participants_in_Events (participant_id, event_id, participant_event_assignment) VALUES (3, 102, False);
```