# Complete Optimization Problem and Solution: manufactory_1

## 1. Problem Context and Goals

### Context  
The manufacturing company is focused on optimizing its production strategy to maximize revenue from product sales. The primary decision involves determining the optimal number of units to produce for each product, which is directly linked to the production quantities stored in the database. The operational parameters are aligned with the goal of maximizing total revenue, calculated as the sum of the product of each product's price and its production quantity. The business configuration includes the total production capacity available across all manufacturers, which serves as a constraint in the optimization model. Additionally, each manufacturer has a specific maximum production capacity that must be respected. The context is framed to ensure that all business decisions and constraints naturally lead to a linear optimization formulation, avoiding any nonlinear relationships such as variable products or divisions. The business configuration parameters, including scalar values and logic formulas, are integrated into the decision-making process to ensure consistency and flexibility in production planning.

### Goals  
The primary goal of the optimization process is to maximize the total revenue generated from product sales. This is achieved by optimizing the production quantities for each product, ensuring that the total revenue, calculated as the sum of the product of each product's price and its production quantity, is maximized. Success is measured by the alignment of the optimization process with the expected coefficient sources, ensuring that the revenue is maximized within the given constraints. The goal is articulated in natural language to emphasize the linear nature of the optimization objective.

## 2. Constraints    

The optimization process is subject to several key constraints that ensure the feasibility of the production plan. The total production capacity available across all manufacturers is a critical constraint, ensuring that the combined production does not exceed the overall capacity. Each manufacturer also has a specific maximum production capacity, which must be adhered to in order to prevent overburdening any single manufacturer. These constraints are described in business terms that naturally lead to linear mathematical forms, ensuring that the optimization problem remains solvable within the defined parameters.

## 3. Available Data  

### Database Schema  
```sql
-- Iteration 1 Database Schema
-- Objective: Schema changes include creating new tables for missing optimization data and updating configuration logic for scalar parameters and formulas.

CREATE TABLE Products (
  Price FLOAT,
  ProductionQuantity FLOAT
);

CREATE TABLE ProductionQuantities (
  ProductID INTEGER,
  Quantity FLOAT
);

CREATE TABLE Manufacturers (
  ManufacturerID INTEGER,
  Capacity INTEGER
);
```

### Data Dictionary  
The data dictionary provides a comprehensive mapping of tables and columns to their business purposes and optimization roles. The "Products" table stores information about each product, including its price and the number of units to produce. This table plays a crucial role in determining the objective coefficients for revenue calculation. The "ProductionQuantities" table links each product to its production quantity, serving as a decision variable in the optimization process. The "Manufacturers" table contains data about each manufacturer's production capacity, which is used as a constraint bound in the optimization model. This business-oriented description ensures a clear connection to the expected linear mathematical formulation.

### Current Stored Values  
```sql
-- Iteration 1 Realistic Data
-- Generated by triple expert (business + data + optimization)
-- Values were determined based on typical manufacturing capacities and product pricing strategies to ensure a realistic and solvable optimization problem.

-- Realistic data for Products
INSERT INTO Products (Price, ProductionQuantity) VALUES (12.99, 150);
INSERT INTO Products (Price, ProductionQuantity) VALUES (18.49, 250);
INSERT INTO Products (Price, ProductionQuantity) VALUES (22.0, 200);

-- Realistic data for ProductionQuantities
INSERT INTO ProductionQuantities (ProductID, Quantity) VALUES (1, 150);
INSERT INTO ProductionQuantities (ProductID, Quantity) VALUES (2, 250);
INSERT INTO ProductionQuantities (ProductID, Quantity) VALUES (3, 200);

-- Realistic data for Manufacturers
INSERT INTO Manufacturers (ManufacturerID, Capacity) VALUES (1, 5000);
INSERT INTO Manufacturers (ManufacturerID, Capacity) VALUES (2, 7000);
INSERT INTO Manufacturers (ManufacturerID, Capacity) VALUES (3, 8000);
```